/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HGUI.BeliefMonitor;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginPrintablePage;
import COM.hugin.HGUI.InstanceNode;
import COM.hugin.HGUI.NetworkPanel;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.UtilityNode;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.util.Date;
import java.util.ListIterator;
import javax.swing.RepaintManager;

public class NodeProbabilitiesPage
extends HuginPrintablePage {
    NetworkPanel network;
    boolean done = false;
    boolean printName;
    boolean printDate;
    ListIterator<Node> nodes;
    boolean all;
    private int lastPrintedPage = -1;
    private int textHeight = 0;

    public NodeProbabilitiesPage(NetworkPanel networkPanel, boolean bl, boolean bl2, boolean bl3) {
        this.network = networkPanel;
        this.all = bl;
        this.nodes = bl ? networkPanel.nodeList.listIterator() : networkPanel.selectedNodes.listIterator();
        this.printName = bl2;
        this.printDate = bl3;
    }

    public void reset() {
        this.lastPrintedPage = -1;
        this.nodes = this.all ? this.network.nodeList.listIterator() : this.network.selectedNodes.listIterator();
        this.done = !this.nodes.hasNext();
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (Math.abs(n - this.lastPrintedPage) > 1) {
            this.moveToPageIndex(n, pageFormat);
        }
        RepaintManager repaintManager = RepaintManager.currentManager(this.network);
        repaintManager.setDoubleBufferingEnabled(false);
        boolean bl = false;
        while (this.nodes.hasNext() && !bl && this.lastPrintedPage == n) {
            int n2 = 0;
            int n3 = 0;
            graphics.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
            if (this.printName) {
                try {
                    this.textHeight = this.printCenteredText(graphics, this.network.projectFrame.getTitle(), (int)pageFormat.getImageableWidth() / 2, 8, 1);
                    n2 += 4 * this.textHeight;
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
            if (this.printDate) {
                this.textHeight = this.printCenteredText(graphics, new Date().toString(), (int)pageFormat.getImageableWidth() / 2, (int)pageFormat.getImageableHeight(), 3);
                if (!this.printName) {
                    n2 += 4 * this.textHeight;
                }
            }
            graphics.translate(0, n2);
            n3 += n2;
            bl = false;
            while (this.nodes.hasNext() && !bl) {
                try {
                    Node node = this.nodes.next();
                    if (node instanceof InstanceNode || node instanceof UtilityNode) continue;
                    BeliefMonitor beliefMonitor = new BeliefMonitor(node, this.network.projectFrame);
                    if (n3 + beliefMonitor.getHeight() > (int)pageFormat.getImageableHeight()) {
                        bl = true;
                        this.nodes.previous();
                        continue;
                    }
                    beliefMonitor.print(graphics);
                    n3 += beliefMonitor.getFullHeight() + 20;
                    graphics.translate(0, beliefMonitor.getFullHeight() + 20);
                }
                catch (Exception exception) {
                    new HuginGUIError(HuginGUIConstants.get("str_unable_to_print_all_nodes_") + exception.getMessage());
                }
            }
        }
        if (!this.done) {
            this.done = !this.nodes.hasNext();
            repaintManager.setDoubleBufferingEnabled(true);
            this.lastPrintedPage = n;
            return 0;
        }
        repaintManager.setDoubleBufferingEnabled(true);
        return 1;
    }

    private void moveToPageIndex(int n, PageFormat pageFormat) {
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            while (this.nodes.hasNext() && !bl) {
                int n2 = 0;
                int n3 = 0;
                if (this.printName) {
                    n2 += 4 * this.textHeight;
                }
                if (this.printDate && !this.printName) {
                    n2 += 4 * this.textHeight;
                }
                n3 += n2;
                bl = false;
                while (this.nodes.hasNext() && !bl) {
                    try {
                        Node node = this.nodes.next();
                        BeliefMonitor beliefMonitor = new BeliefMonitor(node, this.network.projectFrame);
                        if (n3 + beliefMonitor.getHeight() > (int)pageFormat.getImageableHeight()) {
                            bl = true;
                            this.nodes.previous();
                            continue;
                        }
                        n3 += beliefMonitor.getFullHeight() + 20;
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

