/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.DiscreteDecisionNode;
import COM.hugin.HAPI.DiscreteNode;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.FunctionNode;
import COM.hugin.HAPI.Model;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.BarNodeTable;
import COM.hugin.HGUI.ContinuousChanceNode;
import COM.hugin.HGUI.DiscreteChanceNode;
import COM.hugin.HGUI.ExperienceTable;
import COM.hugin.HGUI.ExperienceTableModel;
import COM.hugin.HGUI.ExpressionTable;
import COM.hugin.HGUI.ExpressionTableColumnModel;
import COM.hugin.HGUI.FadingTable;
import COM.hugin.HGUI.FadingTableModel;
import COM.hugin.HGUI.GenericTable;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.InvalidDataException;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.NodePropertiesPane;
import COM.hugin.HGUI.NodeTableColumnModel;
import COM.hugin.HGUI.NodeTableExportPanel;
import COM.hugin.HGUI.NodeTableFrame;
import COM.hugin.HGUI.NodeTableModel;
import COM.hugin.HGUI.UtilityNode;
import COM.hugin.HGUI.Variable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class NodeTable
extends JPanel {
    private GenericTable stateTable = null;
    private GenericTable dataTable = null;
    private ExpressionTable expressionTable = null;
    private ExpressionTable expressionLabelTable = null;
    private FadingTable fadingTable = null;
    private ExperienceTable experienceTable = null;
    private JTable fadingLabelTable = null;
    private JTable experienceLabelTable = null;
    private TableModel stateModel = null;
    private COM.hugin.HAPI.Node node;
    private JScrollBar vertical;
    private JScrollBar horizontal;
    private JScrollBar horizontalExpression;
    Box verticalBox;
    protected int preferredColumnWidth;
    protected int preferredExpressionWidth;
    private JViewport dataTableView;
    private JViewport stateTableView;
    private JPanel dataPanel;
    private JPanel dataAndStatePanel;
    private JPanel headerPanel;
    private JPanel allExceptExpression;
    private JPanel expressionPanel;
    private JPanel expressionDataPanel;
    private JPanel expressionAndLabelPanel;
    private JPanel expressionHeaderPanel;
    private JPanel bottomPanel;
    private Box fadingExperiencePanel;
    private Box fadingExperienceLabelsPanel;
    private boolean showFading;
    private boolean showExperience;
    private boolean showExpressions;
    protected GenericTable.TableTabbedListener tabListener;
    protected GenericTable.TableNeedsScrollListener tableScrollListener;
    protected LinkedList<NodeTableFrame.StateTableChangeListener> stateTableChangeListeners;
    protected LinkedList<NodeTableFrame.TableChangeListener> tableChangeListeners;
    protected LinkedList<NodeTableFrame.StateTableResizedListener> stateTableResizedListeners;
    protected LinkedList<NodeTableFrame.NeedsFakeResizeListener> fakeResizeListeners;
    protected LinkedList<StateDragListener> stateDragListeners;
    private int minimumWidth = 0;
    private int minimumHeight = 0;
    private static final int SEPARATOR_SPACE = 5;
    protected NodeTableFrame.TableChangeListener tableChangeListener;
    private Node guiNode;
    private NodeTableGlassPane glassPane;
    private boolean isStateResizing = false;
    boolean stopExpEditing = true;
    GenericTable focusTable = null;
    int oldHeight = 0;
    int oldWidth = 0;
    private int MAX_WIDTH = Integer.MAX_VALUE;

    public void update2(Graphics graphics) {
        this.glassPane.paintComponent(graphics);
    }

    public NodeTable(Node node) throws ExceptionHugin {
        this(node, null);
    }

    public NodeTable(Node node, COM.hugin.HAPI.Node node2) throws ExceptionHugin {
        COM.hugin.HAPI.Node node3;
        this.setLayout(new BorderLayout(0, 0){

            public void layoutContainer(Container container) {
                if (NodeTable.this.getHeight() == NodeTable.this.oldHeight && NodeTable.this.getWidth() == NodeTable.this.oldWidth) {
                    return;
                }
                NodeTable.this.oldHeight = NodeTable.this.getHeight();
                NodeTable.this.oldWidth = NodeTable.this.getWidth();
                NodeTable.this.resizeTable();
                NodeTable.this.resizeTable();
                super.layoutContainer(container);
            }
        });
        if (node != null) {
            this.setNode(node.getAPINode(), false);
        } else {
            this.setNode(node2, false);
        }
        this.guiNode = node;
        this.preferredColumnWidth = 50;
        this.preferredExpressionWidth = 2 * this.preferredColumnWidth;
        this.showFading = false;
        this.showExperience = false;
        this.allExceptExpression = new JPanel(new BorderLayout(0, 0));
        this.tableChangeListener = new NodeTableFrame.TableChangeListener(){

            public void tableChanged() {
                NodeTable.this.fireTableChanged();
            }
        };
        this.tabListener = new GenericTable.TableTabbedListener(){

            public void tableTabbed(boolean bl, boolean bl2) {
                if (bl2) {
                    if (bl) {
                        NodeTable.this.horizontal.setValue(0);
                    } else {
                        NodeTable.this.horizontal.setValue(NodeTable.this.horizontal.getValue() + 1);
                    }
                } else if (bl) {
                    NodeTable.this.horizontal.setValue(NodeTable.this.horizontal.getMaximum() - NodeTable.this.horizontal.getVisibleAmount());
                } else {
                    NodeTable.this.horizontal.setValue(NodeTable.this.horizontal.getValue() - 1);
                }
            }
        };
        this.tableScrollListener = new GenericTable.TableNeedsScrollListener(){

            public void tableNeedsScroll(int n) {
                NodeTable.this.horizontal.setValue(Math.min(NodeTable.this.horizontal.getValue() + n, NodeTable.this.horizontal.getMaximum()));
            }
        };
        this.dataTable = this.createDataTable();
        this.stateTable = this.createStateTable();
        this.stateTableView = new JViewport();
        this.stateTableView.setView(this.stateTable);
        this.stateTableView.setPreferredSize(this.stateTable.getPreferredSize());
        this.stateTableView.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                NodeTable.this.vertical.setValue(((NodeTable)NodeTable.this).stateTableView.getViewPosition().y);
            }
        });
        this.dataTableView = new JViewport();
        this.dataTableView.setView(this.dataTable);
        this.dataTableView.setPreferredSize(this.dataTable.getPreferredSize());
        this.dataTableView.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                NodeTable.this.vertical.setValue(((NodeTable)NodeTable.this).dataTableView.getViewPosition().y);
            }
        });
        this.dataPanel = new JPanel(new BorderLayout(0, 0));
        this.dataPanel.add(this.dataTableView);
        this.vertical = new JScrollBar(1);
        this.vertical.setValues(0, this.dataTable.getPreferredSize().height, 0, this.dataTable.getPreferredSize().height);
        this.vertical.setUnitIncrement(this.dataTable.getRowHeight());
        this.vertical.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                NodeTable.this.dataTableView.setViewPosition(new Point(0, adjustmentEvent.getValue()));
                NodeTable.this.stateTableView.setViewPosition(new Point(0, adjustmentEvent.getValue()));
            }
        });
        this.horizontal = new JScrollBar(0);
        this.horizontal.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                NodeTable.this.dataTable.invalidate();
                NodeTable.this.dataTable.stopEditing();
                try {
                    NodeTable.this.dataTable.setViewPosition(adjustmentEvent.getValue());
                    NodeTable.this.horizontal.setVisibleAmount(NodeTable.this.dataTable.getColumnCount());
                    if (NodeTable.this.showExperience()) {
                        NodeTable.this.experienceTable.invalidate();
                        NodeTable.this.experienceTable.stopEditing();
                        NodeTable.this.experienceTable.setViewPosition(adjustmentEvent.getValue());
                    }
                    if (NodeTable.this.showFading()) {
                        NodeTable.this.fadingTable.invalidate();
                        NodeTable.this.fadingTable.stopEditing();
                        NodeTable.this.fadingTable.setViewPosition(adjustmentEvent.getValue());
                    }
                }
                catch (ExceptionHugin exceptionHugin) {
                    new HuginGUIError(exceptionHugin);
                }
                NodeTable.this.validate();
                NodeTable.this.repaint();
            }
        });
        this.bottomPanel = new JPanel(new BorderLayout(0, 0));
        this.fadingExperiencePanel = new Box(1);
        this.fadingExperienceLabelsPanel = new Box(1);
        this.verticalBox = new Box(0){

            public void doLayout() {
                if (NodeTable.this.verticalBox.getComponentCount() > 0) {
                    super.doLayout();
                }
            }
        };
        this.headerPanel = new JPanel(new BorderLayout(0, 0));
        this.headerPanel.add(this.dataTable.getTableHeader());
        this.headerPanel.add((Component)this.stateTable.getTableHeader(), "West");
        this.dataAndStatePanel = new JPanel(new BorderLayout(0, 0));
        this.dataAndStatePanel.add(this.dataPanel);
        this.dataAndStatePanel.add((Component)this.stateTableView, "West");
        this.allExceptExpression.add(this.dataAndStatePanel);
        this.allExceptExpression.add((Component)this.headerPanel, "North");
        this.expressionPanel = new JPanel(new BorderLayout(0, 0));
        this.expressionDataPanel = new JPanel(new BorderLayout(0, 0));
        this.expressionAndLabelPanel = new JPanel(new BorderLayout(0, 0));
        this.expressionAndLabelPanel.add(this.expressionDataPanel);
        this.expressionHeaderPanel = new JPanel(new BorderLayout(0, 0));
        this.expressionPanel.add(this.expressionAndLabelPanel);
        this.expressionPanel.add((Component)this.expressionHeaderPanel, "North");
        this.add(this.allExceptExpression);
        this.stateTableChangeListeners = new LinkedList();
        this.stateTableResizedListeners = new LinkedList();
        this.tableChangeListeners = new LinkedList();
        this.fakeResizeListeners = new LinkedList();
        this.stateDragListeners = new LinkedList();
        if ((this.node instanceof COM.hugin.HAPI.DiscreteChanceNode || this.node instanceof DiscreteDecisionNode || this.node instanceof COM.hugin.HAPI.UtilityNode || this.node instanceof FunctionNode) && this.node.getModel() != null) {
            this.showExpressions(true);
        }
        if (this.node instanceof COM.hugin.HAPI.DiscreteChanceNode) {
            node3 = (COM.hugin.HAPI.DiscreteChanceNode)this.node;
            if (((COM.hugin.HAPI.DiscreteChanceNode)node3).hasExperienceTable()) {
                this.showExperience(true);
            }
            if (((COM.hugin.HAPI.DiscreteChanceNode)node3).hasFadingTable()) {
                this.showFading(true);
            }
        }
        if (this.node instanceof COM.hugin.HAPI.ContinuousChanceNode && ((COM.hugin.HAPI.ContinuousChanceNode)(node3 = (COM.hugin.HAPI.ContinuousChanceNode)this.node)).hasExperienceTable()) {
            this.showExperience(true);
        }
        this.glassPane = new NodeTableGlassPane(this);
        this.addStateDragListener(this.createStateDragListener());
        this.resizeTable();
        this.revalidate();
        this.repaint();
    }

    protected void setEditable(boolean bl) {
        this.dataTable.setEditable(bl);
        this.stateTable.setEditable(bl);
        if (this.expressionTable != null) {
            this.expressionTable.setEditable(bl);
        }
        if (this.fadingTable != null) {
            this.fadingTable.setEditable(bl);
        }
        if (this.experienceTable != null) {
            this.experienceTable.setEditable(bl);
        }
    }

    protected void enableDataTable(boolean bl) {
        this.dataTable.setEnabled(bl);
        this.revalidate();
    }

    protected GenericTable createDataTable() throws ExceptionHugin {
        BarNodeTable barNodeTable = new BarNodeTable(this.node);
        barNodeTable.setCellSelectionEnabled(true);
        barNodeTable.setColumnWidth(this.preferredColumnWidth);
        barNodeTable.addColumnListener(new GenericTable.ColumnListener(){

            public void columnCollapsed() {
                NodeTable.this.resizeTable();
                NodeTable.this.revalidate();
                NodeTable.this.repaint();
            }

            public void columnExpanded() {
                NodeTable.this.resizeTable();
                NodeTable.this.revalidate();
                NodeTable.this.repaint();
            }
        });
        barNodeTable.addTableChangeListener(this.tableChangeListener);
        barNodeTable.addTableTabbedListener(this.tabListener);
        barNodeTable.addTableNeedsScrollListener(this.tableScrollListener);
        barNodeTable.addMouseMotionListener(new EndResizeStateTableListener());
        return barNodeTable;
    }

    protected GenericTable createStateTable() throws ExceptionHugin {
        GenericTable genericTable = new GenericTable(this.node, NodeTable.getParents(this.node));
        genericTable.setBackground(UIManager.getDefaults().getColor("Panel.background"));
        genericTable.setColumnWidth(75);
        genericTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                NodeTable.this.fireStateTableChanged(tableModelEvent);
            }
        });
        genericTable.setSelectionMode(0);
        genericTable.setFocusable(this.node instanceof DiscreteNode);
        genericTable.addMouseMotionListener(new ResizeStateTableListener());
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            boolean dragging = false;

            public void mouseDragged(MouseEvent mouseEvent) {
                if (NodeTable.this.isStateResizing()) {
                    return;
                }
                this.dragging = true;
                NodeTable.this.fireStateDrag(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (NodeTable.this.isStateResizing()) {
                    return;
                }
                if (this.dragging) {
                    NodeTable.this.fireStateDragEnded(mouseEvent);
                }
                this.dragging = false;
            }
        };
        genericTable.addMouseListener(mouseInputAdapter);
        genericTable.addMouseMotionListener(mouseInputAdapter);
        return genericTable;
    }

    protected void isStateResizing(boolean bl) {
        this.isStateResizing = bl;
    }

    protected boolean isStateResizing() {
        return this.isStateResizing;
    }

    protected StateDragListener createStateDragListener() {
        return null;
    }

    public Dimension getMinimumSize() {
        this.stopExpEditing = false;
        this.resizeTable();
        this.stopExpEditing = true;
        return new Dimension(this.minimumWidth, this.minimumHeight);
    }

    public void forceVisibleExpressionsRepaint() {
        if (!this.showExpressions) {
            return;
        }
        for (int i = this.expressionTable.getViewPosition(); i < this.expressionTable.getViewPosition() + this.expressionTable.getColumnCount(); ++i) {
            this.expressionTable.setValueAt(this.expressionTable.getValueAt(i, 0), i, 0);
        }
    }

    public void addStateTableChangeListener(NodeTableFrame.StateTableChangeListener stateTableChangeListener) {
        if (stateTableChangeListener != null) {
            this.stateTableChangeListeners.add(stateTableChangeListener);
        }
    }

    public void removeStateTableChangeListener(NodeTableFrame.StateTableChangeListener stateTableChangeListener) {
        this.stateTableChangeListeners.remove(stateTableChangeListener);
    }

    protected void fireStateTableChanged(TableModelEvent tableModelEvent) {
        for (NodeTableFrame.StateTableChangeListener stateTableChangeListener : this.stateTableChangeListeners) {
            stateTableChangeListener.stateTableChanged();
        }
    }

    public void addStateTableResizedListener(NodeTableFrame.StateTableResizedListener stateTableResizedListener) {
        this.stateTableResizedListeners.add(stateTableResizedListener);
    }

    public void removeStateTableResizedListener(NodeTableFrame.StateTableResizedListener stateTableResizedListener) {
        this.stateTableResizedListeners.remove(stateTableResizedListener);
    }

    protected void fireStateTableResized() {
        for (NodeTableFrame.StateTableResizedListener stateTableResizedListener : this.stateTableResizedListeners) {
            stateTableResizedListener.stateTableResized();
        }
    }

    public void addStateDragListener(StateDragListener stateDragListener) {
        if (stateDragListener != null) {
            this.stateDragListeners.add(stateDragListener);
        }
    }

    public void removeStateDragListener(StateDragListener stateDragListener) {
        this.stateDragListeners.remove(stateDragListener);
    }

    protected void fireStateDrag(MouseEvent mouseEvent) {
        for (StateDragListener stateDragListener : this.stateDragListeners) {
            stateDragListener.stateDrag(this.vertical.getValue(), mouseEvent.getY(), mouseEvent.getX());
        }
    }

    protected void fireStateDragEnded(MouseEvent mouseEvent) {
        int n = this.stateTable.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
        for (StateDragListener stateDragListener : this.stateDragListeners) {
            stateDragListener.endDrag(n);
        }
        this.stateTable.getSelectionModel().setSelectionInterval(n, n);
    }

    public void addTableChangeListener(NodeTableFrame.TableChangeListener tableChangeListener) {
        this.tableChangeListeners.add(tableChangeListener);
    }

    public void removeTableChangeListener(NodeTableFrame.TableChangeListener tableChangeListener) {
        this.tableChangeListeners.remove(tableChangeListener);
    }

    protected void fireTableChanged() {
        for (NodeTableFrame.TableChangeListener tableChangeListener : this.tableChangeListeners) {
            tableChangeListener.tableChanged();
        }
    }

    public void addNeedsFakeResizeListener(NodeTableFrame.NeedsFakeResizeListener needsFakeResizeListener) {
        this.fakeResizeListeners.add(needsFakeResizeListener);
    }

    public void removeNeedsFakeResizeListener(NodeTableFrame.NeedsFakeResizeListener needsFakeResizeListener) {
        this.fakeResizeListeners.remove(needsFakeResizeListener);
    }

    protected void fireNeedsFakeResize() {
        for (NodeTableFrame.NeedsFakeResizeListener needsFakeResizeListener : this.fakeResizeListeners) {
            needsFakeResizeListener.makeFakeResize();
        }
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = this.getMinimumSize();
        if (dimension.width < dimension2.width) {
            dimension.width = dimension2.width;
        }
        dimension.height = this.dataTable.getPreferredSize().height + this.dataTable.getTableHeader().getPreferredSize().height;
        if (this.showFading) {
            dimension.height += this.fadingTable.getPreferredSize().height;
        }
        if (this.showExperience) {
            dimension.height += this.experienceTable.getPreferredSize().height;
        }
        if (this.showExpressions) {
            dimension.height += this.expressionTable.getPreferredSize().height;
            dimension.height += this.expressionTable.getTableHeader().getPreferredSize().height;
            if (this.expressionTable.getColumnCount() < this.expressionTable.getTrueColumnCount()) {
                dimension.height += this.horizontalExpression.getPreferredSize().height;
            }
        }
        if (this.dataTable.getColumnCount() < this.dataTable.getTrueColumnCount()) {
            dimension.height += this.horizontal.getPreferredSize().height;
        }
        if (dimension.height < dimension2.height) {
            dimension.height = dimension2.height;
        }
        return dimension;
    }

    protected void showFading(boolean bl) throws ExceptionHugin {
        if (bl == this.showFading || !(this.node instanceof COM.hugin.HAPI.DiscreteChanceNode)) {
            return;
        }
        this.showFading = bl;
        if (bl && this.fadingTable == null) {
            if (this.node instanceof COM.hugin.HAPI.DiscreteChanceNode) {
                this.fadingTable = new FadingTable(this.node, new FadingTableModel((COM.hugin.HAPI.DiscreteChanceNode)this.node), this.dataTable.getColumnModel());
                this.fadingTable.setCellSelectionEnabled(true);
                this.fadingTable.addTableTabbedListener(this.tabListener);
                this.fadingTable.addTableNeedsScrollListener(this.tableScrollListener);
                this.fadingTable.addTableChangeListener(this.tableChangeListener);
                this.fadingLabelTable = new JTable(new FadingTableModel((COM.hugin.HAPI.DiscreteChanceNode)this.node, false), this.stateTable.getColumnModel());
                this.fadingLabelTable.setFocusable(false);
                this.fadingLabelTable.setBackground(UIManager.getDefaults().getColor("Panel.background"));
            }
        } else if (bl) {
            this.fadingTable.changeNode(this.node);
        }
        this.resizeTable();
        this.revalidate();
    }

    protected boolean showFading() {
        return this.showFading;
    }

    protected void showExperience(boolean bl) throws ExceptionHugin {
        if (bl == this.showExperience) {
            return;
        }
        this.showExperience = bl;
        if (this.experienceTable == null) {
            if (this.node instanceof COM.hugin.HAPI.DiscreteChanceNode) {
                this.experienceTable = new ExperienceTable(this.node, new ExperienceTableModel((COM.hugin.HAPI.DiscreteChanceNode)this.node), this.dataTable.getColumnModel());
                this.experienceTable.addTableTabbedListener(this.tabListener);
                this.experienceTable.addTableNeedsScrollListener(this.tableScrollListener);
                this.experienceTable.addTableChangeListener(this.tableChangeListener);
                this.experienceTable.setCellSelectionEnabled(true);
                this.experienceLabelTable = new JTable(new ExperienceTableModel((COM.hugin.HAPI.DiscreteChanceNode)this.node, false), this.stateTable.getColumnModel());
                this.experienceLabelTable.setFocusable(false);
                this.experienceLabelTable.setBackground(UIManager.getDefaults().getColor("Panel.background"));
            } else if (this.node instanceof COM.hugin.HAPI.ContinuousChanceNode) {
                this.experienceTable = new ExperienceTable(this.node, new ExperienceTableModel((COM.hugin.HAPI.ContinuousChanceNode)this.node), this.dataTable.getColumnModel());
                this.experienceTable.addTableTabbedListener(this.tabListener);
                this.experienceTable.addTableNeedsScrollListener(this.tableScrollListener);
                this.experienceTable.addTableChangeListener(this.tableChangeListener);
                this.experienceTable.setCellSelectionEnabled(true);
                this.experienceLabelTable = new JTable(new ExperienceTableModel((COM.hugin.HAPI.ContinuousChanceNode)this.node, false), this.stateTable.getColumnModel());
                this.experienceLabelTable.setFocusable(false);
                this.experienceLabelTable.setBackground(UIManager.getDefaults().getColor("Panel.background"));
            }
        } else if (bl) {
            this.experienceTable.changeNode(this.node);
        }
        this.resizeTable();
        this.revalidate();
    }

    protected boolean showExperience() {
        return this.showExperience;
    }

    protected void updateExperienceAndFading() {
        try {
            if (this.node instanceof COM.hugin.HAPI.DiscreteChanceNode) {
                COM.hugin.HAPI.DiscreteChanceNode discreteChanceNode = (COM.hugin.HAPI.DiscreteChanceNode)this.node;
                if (discreteChanceNode.hasFadingTable()) {
                    if (!this.showFading) {
                        this.showFading(true);
                    }
                } else if (this.showFading) {
                    this.showFading(false);
                }
                if (discreteChanceNode.hasExperienceTable()) {
                    if (!this.showExperience) {
                        this.showExperience(true);
                    }
                } else if (this.showExperience) {
                    this.showExperience(false);
                }
            } else if (this.node instanceof COM.hugin.HAPI.ContinuousChanceNode) {
                COM.hugin.HAPI.ContinuousChanceNode continuousChanceNode = (COM.hugin.HAPI.ContinuousChanceNode)this.node;
                if (continuousChanceNode.hasExperienceTable()) {
                    if (!this.showExperience) {
                        this.showExperience(true);
                    }
                } else if (this.showExperience) {
                    this.showExperience(false);
                }
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            new HuginGUIError(exceptionHugin);
        }
    }

    protected void stopEditing() {
        this.dataTable.stopEditing();
        if (this.expressionTable != null) {
            this.expressionTable.stopEditing();
        }
        this.stateTable.stopEditing();
        if (this.experienceTable != null) {
            this.experienceTable.stopEditing();
        }
        if (this.fadingTable != null) {
            this.fadingTable.stopEditing();
        }
    }

    protected void showExpressions(boolean bl) throws ExceptionHugin {
        if (bl == this.showExpressions) {
            return;
        }
        this.showExpressions = bl;
        this.dataTable.stopEditing();
        if (this.expressionTable != null) {
            this.expressionTable.stopEditing();
        }
        if (bl && this.expressionTable == null) {
            this.expressionAndLabelPanel.removeAll();
            this.expressionTable = this.createExpressionTable(this.node);
            this.expressionTable.addTableChangeListener(new NodeTableFrame.TableChangeListener(){

                public void tableChanged() {
                    NodeTable.this.dataTable.invalidateModel();
                }
            });
            this.expressionTable.addTableChangeListener(this.tableChangeListener);
            this.expressionLabelTable = new ExpressionTable(this.node, this.node.getModel().getNodes());
            this.expressionLabelTable.setBackground(this.expressionPanel.getBackground());
            this.expressionLabelTable.setFocusable(false);
            this.expressionDataPanel.add(this.expressionTable);
            this.expressionAndLabelPanel.add(this.expressionDataPanel);
            this.expressionAndLabelPanel.add((Component)this.expressionLabelTable, "West");
            this.expressionHeaderPanel.add(this.expressionTable.getTableHeader());
            this.expressionHeaderPanel.add((Component)this.expressionLabelTable.getTableHeader(), "West");
            this.horizontalExpression = new JScrollBar(0);
            this.horizontalExpression.addAdjustmentListener(new AdjustmentListener(){

                public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    NodeTable.this.expressionTable.invalidate();
                    NodeTable.this.expressionTable.stopEditing();
                    try {
                        NodeTable.this.expressionTable.setViewPosition(adjustmentEvent.getValue());
                        NodeTable.this.horizontalExpression.setVisibleAmount(NodeTable.this.expressionTable.getColumnCount());
                    }
                    catch (Exception exception) {
                        new HuginGUIError(exception);
                    }
                    NodeTable.this.validate();
                    NodeTable.this.repaint();
                }
            });
        }
        this.expressionPanel.removeAll();
        if (bl) {
            this.expressionPanel.add(this.expressionAndLabelPanel);
            this.expressionPanel.add((Component)this.expressionHeaderPanel, "North");
            this.expressionPanel.add(Box.createVerticalStrut(5), "South");
            this.dataTable.store();
            this.dataTable.invalidateModel();
            try {
                this.expressionTable.restoreExpressions();
            }
            catch (Exception exception) {
                this.expressionTable.changeNode(this.node);
                this.expressionHeaderPanel.removeAll();
                this.expressionHeaderPanel.add(this.expressionTable.getTableHeader());
                this.expressionLabelTable.changeNode(this.node, new NodeList());
                this.expressionHeaderPanel.add((Component)this.expressionLabelTable.getTableHeader(), "West");
            }
        } else {
            this.dataTable.restore();
            if (this.expressionTable != null) {
                this.expressionTable.store();
            }
        }
        ((NodeTableModel)this.dataTable.getModel()).setExpressionMode(bl);
        this.dataTable.setEnabled(!bl);
        this.oldHeight = -1;
        this.resizeTable();
        this.revalidate();
    }

    public JTable getTable() {
        return this.dataTable;
    }

    protected boolean showExpressions() {
        return this.showExpressions;
    }

    protected boolean canShowExpressions() {
        return this.node instanceof COM.hugin.HAPI.DiscreteChanceNode || this.node instanceof COM.hugin.HAPI.UtilityNode || this.node instanceof DiscreteDecisionNode || this.node instanceof FunctionNode;
    }

    protected void modelDeleted() throws ExceptionHugin {
        this.modelDeleted(true);
    }

    protected void modelDeleted(boolean bl) throws ExceptionHugin {
        this.expressionTable = null;
        this.expressionLabelTable = null;
        this.expressionHeaderPanel.removeAll();
        this.expressionPanel.removeAll();
        this.expressionDataPanel.removeAll();
        this.expressionAndLabelPanel.removeAll();
        if (bl) {
            this.showExpressions(false);
        }
    }

    private ExpressionTable createExpressionTable(COM.hugin.HAPI.Node node) throws ExceptionHugin {
        ExpressionTable expressionTable = new ExpressionTable(node);
        expressionTable.setCellSelectionEnabled(true);
        expressionTable.addColumnListener(new GenericTable.ColumnListener(){

            public void columnCollapsed() {
                NodeTable.this.resizeTable();
                NodeTable.this.revalidate();
                NodeTable.this.repaint();
                NodeTable.this.fireNeedsFakeResize();
            }

            public void columnExpanded() {
                NodeTable.this.resizeTable();
                NodeTable.this.revalidate();
                NodeTable.this.repaint();
                NodeTable.this.fireNeedsFakeResize();
            }
        });
        expressionTable.addTableTabbedListener(new GenericTable.TableTabbedListener(){

            public void tableTabbed(boolean bl, boolean bl2) {
                if (bl2) {
                    if (bl) {
                        NodeTable.this.horizontalExpression.setValue(0);
                    } else {
                        NodeTable.this.horizontalExpression.setValue(NodeTable.this.horizontalExpression.getValue() + 1);
                    }
                } else if (bl) {
                    NodeTable.this.horizontalExpression.setValue(NodeTable.this.horizontalExpression.getMaximum() - NodeTable.this.horizontalExpression.getVisibleAmount());
                } else {
                    NodeTable.this.horizontalExpression.setValue(NodeTable.this.horizontalExpression.getValue() - 1);
                }
            }
        });
        return expressionTable;
    }

    protected void generateTable() throws ExceptionHugin {
        if (this.showExpressions) {
            ((NodeTableModel)this.dataTable.getModel()).generate();
            this.fireTableChanged();
        }
    }

    protected void transferToCPT() throws ExceptionHugin {
        if (this.showExpressions) {
            ((NodeTableModel)this.dataTable.getModel()).generate();
            this.dataTable.store();
            this.fireTableChanged();
        }
    }

    protected void addModelNode(COM.hugin.HAPI.Node node) throws ExceptionHugin {
        int n = this.node.getModel().getNumberOfSamplesPerInterval();
        String[] stringArray = new String[this.expressionTable.getTrueColumnCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)this.expressionTable.getModel().getValueAt(1, i);
        }
        NodeList nodeList = this.node.getModel().getNodes();
        nodeList.add(node);
        new Model(this.node, nodeList);
        this.node.getModel().setNumberOfSamplesPerInterval(n);
        for (int i = 0; i < stringArray.length; ++i) {
            this.expressionTable.getModel().setValueAt(stringArray[i], 1, i);
        }
        this.expressionTable.setNode(this.node);
        this.expressionLabelTable.changeNode(this.node, this.node.getModel().getNodes());
        this.oldHeight = -1;
        this.resizeTable();
    }

    protected void removeModelNode(COM.hugin.HAPI.Node node) throws ExceptionHugin {
        int n = this.node.getModel().getNumberOfSamplesPerInterval();
        String[] stringArray = new String[this.expressionTable.getTrueColumnCount()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)this.expressionTable.getModel().getValueAt(1, i);
        }
        NodeList nodeList = this.node.getModel().getNodes();
        nodeList.remove(node);
        Model model = new Model(this.node, nodeList);
        this.node.getModel().setNumberOfSamplesPerInterval(n);
        for (int i = 0; i < model.getSize(); ++i) {
            this.expressionTable.getModel().setValueAt(stringArray[i], 1, i);
        }
        this.expressionTable.setNode(this.node);
        this.expressionLabelTable.changeNode(this.node, this.node.getModel().getNodes());
        this.oldHeight = -1;
        this.resizeTable();
    }

    protected int getPreferredColumnWidth() {
        return this.preferredColumnWidth;
    }

    protected void setPreferredColumnWidth(int n) {
        this.preferredColumnWidth = n;
        this.resizeTable();
        this.revalidate();
    }

    protected void convertNode(int n, Node node) throws ExceptionHugin {
        NodePropertiesPane.setType(this.node.getHome(), node, n);
    }

    protected void setNode(COM.hugin.HAPI.Node node, boolean bl) {
        this.node = node;
    }

    protected COM.hugin.HAPI.Node getNode() {
        return this.node;
    }

    protected void setNode(COM.hugin.HAPI.Node node) throws ExceptionHugin {
        boolean bl;
        this.node = node;
        this.dataTable.changeNode(node);
        this.stateTable.changeNode(node, NodeTable.getParents(node));
        this.stateTable.getModel().addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                NodeTable.this.fireStateTableChanged(tableModelEvent);
            }
        });
        if (this.vertical != null) {
            this.vertical.setValue(0);
        }
        if (this.horizontal != null) {
            this.horizontal.setValue(0);
        }
        boolean bl2 = node instanceof COM.hugin.HAPI.DiscreteChanceNode && ((COM.hugin.HAPI.DiscreteChanceNode)node).hasFadingTable();
        boolean bl3 = bl = node instanceof COM.hugin.HAPI.DiscreteChanceNode && ((COM.hugin.HAPI.DiscreteChanceNode)node).hasExperienceTable() || node instanceof COM.hugin.HAPI.ContinuousChanceNode && ((COM.hugin.HAPI.ContinuousChanceNode)node).hasExperienceTable();
        if (this.experienceTable != null && bl) {
            ((ExperienceTableModel)this.experienceTable.getModel()).setNode(node);
        } else {
            this.showExperience(false);
        }
        if (this.fadingTable != null && bl2) {
            ((FadingTableModel)this.fadingTable.getModel()).setNode(node);
        } else {
            this.showFading(false);
        }
        if (this.expressionTable != null && this.showExpressions()) {
            if (node.getModel() != null) {
                this.expressionTable.changeNode(node);
                this.expressionLabelTable.changeNode(node, node.getModel().getNodes());
            } else {
                this.expressionTable = null;
            }
            this.dataTable.store();
            this.dataTable.invalidateModel();
        }
        this.headerPanel.revalidate();
        this.oldHeight = -1;
        this.getStateTable().getTableHeader().resizeAndRepaint();
        this.getCPT().getTableHeader().resizeAndRepaint();
        if (this.getExpressionTable() != null) {
            this.getExpressionTable().getTableHeader().resizeAndRepaint();
            this.expressionLabelTable.getTableHeader().resizeAndRepaint();
        }
    }

    protected static NodeList getParents(COM.hugin.HAPI.Node node) throws ExceptionHugin {
        NodeList nodeList = null;
        if (node instanceof DiscreteNode) {
            nodeList = node.getTable().getNodes();
        }
        if (node instanceof COM.hugin.HAPI.UtilityNode || node instanceof COM.hugin.HAPI.ContinuousChanceNode) {
            nodeList = node.getTable().getNodes();
        }
        if (nodeList != null) {
            nodeList.remove(node);
        }
        if (node instanceof FunctionNode) {
            nodeList = new NodeList();
        }
        return nodeList;
    }

    protected void setDisplayMode(int n) throws ExceptionHugin {
        this.dataTable.stopEditing();
        if (this.dataTable instanceof BarNodeTable) {
            ((BarNodeTable)this.dataTable).setDisplayMode(n);
        }
        this.dataTable.revalidate();
        this.dataTable.repaint();
    }

    public void setPrecisionForAll(int n) throws ExceptionHugin {
        for (Node node : this.guiNode.panel.nodeList) {
            this.guiNode.panel.getHome().setAttribute("HR_Node_TablePrecision", "" + n);
            if (!(node instanceof DiscreteChanceNode) && !(node instanceof ContinuousChanceNode) && !(node instanceof UtilityNode)) continue;
            node.getAPINode().setAttribute("HR_TablePrecision", null);
            node.updateTable();
        }
    }

    public void setPrecision(int n) throws ExceptionHugin {
        this.dataTable.setPrecision(n);
        this.dataTable.revalidate();
        this.dataTable.repaint();
        if (this.experienceTable != null) {
            this.experienceTable.revalidate();
            this.experienceTable.repaint();
        }
        if (this.fadingTable != null) {
            this.fadingTable.revalidate();
            this.fadingTable.repaint();
        }
    }

    public int getPrecision() {
        return this.dataTable.getPrecision();
    }

    public void setForceDecimals(boolean bl) throws ExceptionHugin {
        this.dataTable.setForceDecimals(bl);
        this.dataTable.revalidate();
        this.dataTable.repaint();
        if (this.experienceTable != null) {
            this.experienceTable.revalidate();
            this.experienceTable.repaint();
        }
        if (this.fadingTable != null) {
            this.fadingTable.revalidate();
            this.fadingTable.repaint();
        }
    }

    public void setForceDecimalsForAll(boolean bl) throws ExceptionHugin {
        for (Node node : this.guiNode.panel.nodeList) {
            this.guiNode.panel.getHome().setAttribute("HR_Node_ForceDecimalView", "" + bl);
            if (!(node instanceof DiscreteChanceNode) && !(node instanceof ContinuousChanceNode) && !(node instanceof UtilityNode)) continue;
            node.getAPINode().setAttribute("HR_ForceDecimalView", null);
            node.updateTable();
        }
    }

    public boolean getForceDecimals() {
        return this.dataTable.getForceDecimals();
    }

    public Node getGUINode() {
        return this.guiNode;
    }

    protected void autoNormalize(boolean bl) throws ExceptionHugin {
        if (this.dataTable instanceof BarNodeTable) {
            ((BarNodeTable)this.dataTable).autoNormalize(bl);
        }
    }

    protected int getDisplayMode() {
        if (this.dataTable instanceof BarNodeTable) {
            return ((BarNodeTable)this.dataTable).getDisplayMode();
        }
        return -1;
    }

    protected boolean autoNormalize() {
        if (this.dataTable instanceof BarNodeTable) {
            return ((BarNodeTable)this.dataTable).autoNormalize();
        }
        return false;
    }

    public boolean copySelection() {
        boolean bl = false;
        if (this.focusTable != null) {
            bl = this.focusTable.copySelection();
        }
        return bl;
    }

    public boolean pasteSelection() throws IOException, UnsupportedFlavorException {
        boolean bl = false;
        if (this.focusTable != null) {
            bl = this.focusTable.pasteSelection();
        }
        return bl;
    }

    public void resetCPT() throws ExceptionHugin {
        if (this.node instanceof COM.hugin.HAPI.ContinuousChanceNode) {
            this.dataTable.reset(0);
        } else {
            this.dataTable.reset(1);
        }
        this.dataTable.repaint();
    }

    public void resetFading() throws ExceptionHugin {
        this.fadingTable.reset(1);
        this.fadingTable.repaint();
    }

    public void resetExperience() throws ExceptionHugin {
        this.experienceTable.reset(0);
        this.experienceTable.repaint();
    }

    public void exportTable(NodeTableExportPanel nodeTableExportPanel) throws ExceptionHugin, IOException {
        switch (nodeTableExportPanel.getOperation()) {
            case 1: {
                PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(nodeTableExportPanel.getFile())));
                printWriter.println("\\documentclass{article}");
                printWriter.println();
                printWriter.println("\\begin{document}");
                printWriter.println("\\section{" + HuginGUIUtils.getNodeTitle(this.node) + "}");
                printWriter.println("\\begin{table}[htbp]");
                printWriter.println("\\centering");
                if (this.showExpressions()) {
                    this.expressionTable.export(printWriter, nodeTableExportPanel);
                } else {
                    this.dataTable.export(printWriter, nodeTableExportPanel);
                    if (this.showExperience()) {
                        this.experienceTable.export(printWriter, nodeTableExportPanel);
                    }
                    if (this.showFading()) {
                        this.fadingTable.export(printWriter, nodeTableExportPanel);
                    }
                }
                printWriter.println("\\end{tabular}");
                printWriter.println("\\caption{The conditional probability table of " + HuginGUIUtils.getNodeTitle(this.node) + "}");
                printWriter.println("\\end{table}");
                printWriter.println();
                printWriter.println("\\end{document}");
                printWriter.close();
                break;
            }
            case 0: {
                PrintWriter printWriter = null;
                try {
                    printWriter = new PrintWriter(new BufferedWriter(new FileWriter(nodeTableExportPanel.getFile())));
                }
                catch (Exception exception) {
                    new HuginGUIError(exception.getMessage());
                    break;
                }
                printWriter.println("---------- " + HuginGUIUtils.getNodeTitle(this.node) + " ----------");
                if (this.showExpressions()) {
                    this.expressionTable.export(printWriter, nodeTableExportPanel);
                } else {
                    this.dataTable.export(printWriter, nodeTableExportPanel);
                    if (this.showExperience()) {
                        this.experienceTable.export(printWriter, nodeTableExportPanel);
                    }
                    if (this.showFading()) {
                        this.fadingTable.export(printWriter, nodeTableExportPanel);
                    }
                }
                printWriter.close();
                break;
            }
        }
    }

    public void importTable(File file) throws InvalidDataException, ExceptionHugin, IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        int n = 0;
        String string = bufferedReader.readLine();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (string != null) {
            boolean bl;
            boolean bl2 = bl = stringTokenizer.countTokens() == this.dataTable.getTrueColumnCount();
            if (bl) {
                while (stringTokenizer.hasMoreTokens() && bl) {
                    Variable.atof(stringTokenizer.nextToken());
                    bl = Variable.numberWasValid;
                }
            }
            if ((string = bufferedReader.readLine()) != null) {
                stringTokenizer = new StringTokenizer(string, ",");
            }
            if (!bl) continue;
            ++n;
        }
        if (n != this.dataTable.getRowCount()) {
            throw new InvalidDataException(HuginGUIConstants.get("str_unable_to_import_table_from_file_the_file_contains_") + n + HuginGUIConstants.get("str__lines_should_be_") + this.dataTable.getRowCount() + HuginGUIConstants.get("str__with_the_correct_number_of_values_") + this.dataTable.getTrueColumnCount() + HuginGUIConstants.get("str_endpar_"));
        }
        bufferedReader = new BufferedReader(new FileReader(file));
        n = 0;
        string = bufferedReader.readLine();
        stringTokenizer = new StringTokenizer(string, ",");
        while (string != null) {
            boolean bl;
            boolean bl3 = bl = stringTokenizer.countTokens() == this.dataTable.getTrueColumnCount();
            if (bl) {
                while (stringTokenizer.hasMoreTokens() && bl) {
                    Variable.atof(stringTokenizer.nextToken());
                    bl = Variable.numberWasValid;
                }
            }
            if (bl) {
                int n2 = 0;
                stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens() && bl) {
                    double d = Variable.atof(stringTokenizer.nextToken());
                    this.dataTable.getModel().setValueAt(new Double(d), n, n2);
                    ++n2;
                }
            }
            if ((string = bufferedReader.readLine()) != null) {
                stringTokenizer = new StringTokenizer(string, ",");
            }
            if (!bl) continue;
            ++n;
        }
        this.dataTable.repaint();
    }

    public void randomizeCPT() throws ExceptionHugin {
        if (this.node instanceof COM.hugin.HAPI.DiscreteChanceNode && ((COM.hugin.HAPI.DiscreteChanceNode)this.node).hasExperienceTable()) {
            this.dataTable.randomize(((COM.hugin.HAPI.DiscreteChanceNode)this.node).getExperienceTable());
        } else {
            this.dataTable.randomize(null);
        }
        this.dataTable.repaint();
    }

    protected Model getModel(NodeList nodeList) throws ExceptionHugin {
        return new Model(this.node, nodeList);
    }

    public boolean canCopy() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (!(component instanceof GenericTable)) {
            this.focusTable = null;
            return false;
        }
        this.focusTable = (GenericTable)component;
        return ((GenericTable)component).canCopy();
    }

    public boolean canPaste() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (!(component instanceof GenericTable)) {
            return false;
        }
        return ((GenericTable)component).canPaste();
    }

    public boolean hasSelection() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (!(component instanceof GenericTable)) {
            return false;
        }
        return ((GenericTable)component).hasSelection();
    }

    public void createExperience() throws ExceptionHugin {
        if (this.node instanceof COM.hugin.HAPI.DiscreteChanceNode) {
            ((COM.hugin.HAPI.DiscreteChanceNode)this.node).getExperienceTable();
        }
        if (this.node instanceof COM.hugin.HAPI.ContinuousChanceNode) {
            ((COM.hugin.HAPI.ContinuousChanceNode)this.node).getExperienceTable();
        }
        this.fireTableChanged();
    }

    public void createFading() throws ExceptionHugin {
        if (this.node instanceof COM.hugin.HAPI.DiscreteChanceNode) {
            ((COM.hugin.HAPI.DiscreteChanceNode)this.node).getFadingTable();
        }
    }

    public void deleteExperience() throws ExceptionHugin {
        if (this.node instanceof COM.hugin.HAPI.DiscreteChanceNode) {
            ((COM.hugin.HAPI.DiscreteChanceNode)this.node).getExperienceTable().delete();
        }
        if (this.node instanceof COM.hugin.HAPI.ContinuousChanceNode) {
            ((COM.hugin.HAPI.ContinuousChanceNode)this.node).getExperienceTable().delete();
        }
        this.fireTableChanged();
    }

    public void deleteFading() throws ExceptionHugin {
        if (this.node instanceof COM.hugin.HAPI.DiscreteChanceNode) {
            ((COM.hugin.HAPI.DiscreteChanceNode)this.node).getFadingTable().delete();
        }
    }

    public boolean hasExperience() throws ExceptionHugin {
        if (this.node instanceof COM.hugin.HAPI.DiscreteChanceNode) {
            return ((COM.hugin.HAPI.DiscreteChanceNode)this.node).hasExperienceTable();
        }
        if (this.node instanceof COM.hugin.HAPI.ContinuousChanceNode) {
            return ((COM.hugin.HAPI.ContinuousChanceNode)this.node).hasExperienceTable();
        }
        return false;
    }

    public boolean hasFading() throws ExceptionHugin {
        if (this.node instanceof COM.hugin.HAPI.DiscreteChanceNode) {
            return ((COM.hugin.HAPI.DiscreteChanceNode)this.node).hasFadingTable();
        }
        return false;
    }

    public GenericTable getCPT() {
        return this.dataTable;
    }

    public ExpressionTable getExpressionTable() {
        return this.expressionTable;
    }

    public GenericTable getStateTable() {
        return this.stateTable;
    }

    protected JViewport getStateTableView() {
        return this.stateTableView;
    }

    public ExperienceTable getExperienceTable() {
        return this.experienceTable;
    }

    public FadingTable getFadingTable() {
        return this.fadingTable;
    }

    protected void setMaxBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.MAX_WIDTH = n3;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        if (n3 > this.MAX_WIDTH) {
            return;
        }
        super.setBounds(n, n2, n3, n4);
    }

    protected void resizeTable() {
        int n = 0;
        int n2 = 0;
        int n3 = this.getHeight();
        int n4 = this.getWidth();
        int n5 = 5;
        int n6 = 0;
        int n7 = 0;
        NodeTableColumnModel nodeTableColumnModel = (NodeTableColumnModel)this.dataTable.getColumnModel();
        try {
            this.dataTable.stopEditing();
            this.stateTable.stopEditing();
            int n8 = this.dataTable.getTrueColumnCount();
            n6 += this.dataTable.getTableHeader().getPreferredSize().height;
            if (n > 0) {
                n6 += this.horizontal.getPreferredSize().height;
            }
            if (this.showExpressions) {
                if (this.stopExpEditing) {
                    this.expressionTable.stopEditing();
                }
                this.resizeExpressionTable(n4);
                n6 += this.expressionPanel.getPreferredSize().height;
            }
            if (this.showFading) {
                this.fadingTable.stopEditing();
                n6 += this.fadingTable.getPreferredSize().height;
            }
            if (this.showExperience) {
                this.experienceTable.stopEditing();
                n6 += this.experienceTable.getPreferredSize().height;
            }
            if (this.showFading || this.showExperience) {
                n6 += n5;
            }
            n7 = this.stateTable.getPreferredSize().width;
            n = nodeTableColumnModel.getMaxTotalColumnWidth() - (n4 - n7);
            n2 = this.stateTable.getPreferredSize().height - (n3 - n6);
            if (n > 0) {
                n2 += this.horizontal.getPreferredSize().height;
                n6 += this.horizontal.getPreferredSize().height;
            }
            int n9 = n;
            if (n2 > 0) {
                n += this.vertical.getPreferredSize().width;
                n7 += this.vertical.getPreferredSize().width;
            }
            if (n9 < 0 && n > 0) {
                n2 += this.horizontal.getPreferredSize().height;
                n6 += this.horizontal.getPreferredSize().height;
            }
            nodeTableColumnModel.setAvailableWidth(n4 - n7);
            int n10 = this.dataTable.getColumnCount();
            n8 = nodeTableColumnModel.getTrueColumnCount();
            this.bottomPanel.removeAll();
            this.fadingExperiencePanel.removeAll();
            this.fadingExperienceLabelsPanel.removeAll();
            this.verticalBox.removeAll();
            if (n10 <= 0) {
                boolean bl = false;
            } else {
                int n11 = (n4 - n7) / n10;
            }
            if (this.showExpressions) {
                this.add((Component)this.expressionPanel, "North");
            } else {
                this.remove(this.expressionPanel);
            }
            if (this.showFading || this.showExperience) {
                this.fadingExperiencePanel.add(Box.createVerticalStrut(n5));
                this.fadingExperienceLabelsPanel.add(Box.createVerticalStrut(n5));
            }
            if (this.showExperience) {
                this.fadingExperiencePanel.add(this.experienceTable);
                this.fadingExperienceLabelsPanel.add(this.experienceLabelTable);
            }
            if (this.showFading) {
                this.fadingExperiencePanel.add(this.fadingTable);
                this.fadingExperienceLabelsPanel.add(this.fadingLabelTable);
            }
            this.bottomPanel.add(this.fadingExperiencePanel);
            this.bottomPanel.add((Component)this.fadingExperienceLabelsPanel, "West");
            if (n10 > 0) {
                this.dataTable.setVisibleColumns(n10);
                if (n10 < n8) {
                    this.horizontal.setMinimum(0);
                    this.horizontal.setMaximum(n8);
                    if (this.horizontal.getMaximum() - n10 < this.horizontal.getValue()) {
                        this.horizontal.setValue(this.horizontal.getMaximum() - n10);
                    }
                    this.horizontal.setBlockIncrement(n10);
                    this.horizontal.setVisibleAmount(n10);
                    this.fadingExperiencePanel.add(this.horizontal);
                    Dimension dimension = new Dimension(0, 0);
                    dimension.height = this.horizontal.getPreferredSize().height;
                    dimension.width = this.stateTableView.getPreferredSize().width;
                    this.fadingExperienceLabelsPanel.add(Box.createRigidArea(new Dimension(dimension)), "West");
                } else {
                    this.horizontal.setValue(0);
                }
            }
            boolean bl = false;
            int n12 = n4 - n7 - nodeTableColumnModel.getTotalColumnWidth();
            if (n2 > 0) {
                int n13 = n3 - n6;
                int n14 = this.stateTable.getPreferredSize().height;
                if (this.vertical.getValue() > n14 - n13) {
                    this.vertical.setValue(n14 - n13);
                }
                this.vertical.setMaximum(n14);
                this.vertical.setVisibleAmount(n13);
                this.verticalBox.add(this.vertical);
                this.verticalBox.add(Box.createHorizontalStrut(n12));
                this.dataPanel.add((Component)this.verticalBox, "East");
                if (n > 0) {
                    Dimension dimension = new Dimension(0, 0);
                    dimension.height = this.horizontal.getPreferredSize().height;
                    dimension.width = this.vertical.getPreferredSize().width + n12;
                    this.bottomPanel.add(Box.createRigidArea(dimension), "East");
                }
            }
            if (n2 < 0) {
                this.bottomPanel.add(Box.createVerticalStrut(-n2), "South");
            }
            this.add((Component)this.bottomPanel, "South");
            this.minimumWidth = n7 + 2 * this.preferredColumnWidth;
            this.minimumHeight = n6 + this.stateTable.getRowHeight();
            if (n8 > 2 && n <= 0) {
                this.minimumHeight += this.horizontal.getPreferredSize().height;
            }
            if (this.stateTable.getRowCount() > 1 && n2 <= 0) {
                this.minimumWidth += this.vertical.getPreferredSize().width;
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    protected void resizeExpressionTable(int n) throws ExceptionHugin {
        int n2;
        int n3 = ((ExpressionTableColumnModel)this.expressionTable.getColumnModel()).setAvailableWidth(n - this.expressionLabelTable.getPreferredSize().width);
        if (n3 < 1) {
            n3 = 1;
        }
        if ((n3 = Math.min(n3, n2 = this.expressionTable.getTrueColumnCount())) < n2) {
            int n4 = this.horizontalExpression.getValue();
            if (n4 + n3 > n2) {
                n4 = this.expressionTable.getTrueColumnCount() - n3;
            }
            this.horizontalExpression.setValues(n4, n3, 0, n2);
            this.expressionDataPanel.add((Component)this.horizontalExpression, "South");
        } else {
            this.expressionDataPanel.invalidate();
            this.expressionDataPanel.remove(this.horizontalExpression);
        }
    }

    public void dispose() {
        this.stateTable.setModel(new DefaultTableModel());
        this.dataTable.setModel(new DefaultTableModel());
        if (this.expressionTable != null) {
            this.expressionTable.setModel(new DefaultTableModel());
        }
        if (this.fadingTable != null) {
            this.fadingTable.setModel(new DefaultTableModel());
        }
        if (this.experienceTable != null) {
            this.experienceTable.setModel(new DefaultTableModel());
        }
    }

    public int getRowCount() {
        if (this.showExpressions()) {
            return this.expressionTable.getRowCount();
        }
        return this.dataTable.getRowCount();
    }

    public void setStateDisplayMode(int n) throws ExceptionHugin {
        this.stateTable.setStateDisplayMode(n);
    }

    public int getStateDisplayMode() {
        return ((NodeTableModel)this.stateTable.getModel()).getDisplayMode();
    }

    private class NodeTableGlassPane
    extends JPanel {
        private int y = 0;
        private int row = -1;
        private int orgY;
        private int orgRow;
        private int yOffset;
        private int scrollPos;
        private NodeTable table;
        private TableCellRenderer renderer;
        private GenericTable stateTable;
        private int cellHeight = 0;
        private int cellWidth = 0;
        private int rowCount = 0;
        private int height = 0;
        private Point p;

        public NodeTableGlassPane(NodeTable nodeTable2) {
            this.table = nodeTable2;
            this.stateTable = nodeTable2.getStateTable();
            this.renderer = this.stateTable.getDefaultRenderer(Object.class);
            this.cellHeight = this.stateTable.getRowHeight();
            this.setOpaque(true);
        }

        public void init(int n, int n2) {
            this.scrollPos = n;
            this.orgRow = n2 / this.cellHeight;
            this.orgY = n2;
            this.rowCount = this.stateTable.getRowCount();
            this.yOffset = SwingUtilities.convertPoint((Component)this.stateTable, (int)0, (int)0, (Component)this.getRootPane()).y;
            this.height = this.table.getStateTableView().getHeight();
            this.cellWidth = this.stateTable.getWidth();
            this.p = SwingUtilities.convertPoint(this.stateTable, 0, 0, this);
        }

        public int getOriginalRow() {
            return this.orgRow;
        }

        public void update(int n, int n2) {
            this.y = n;
            if (this.y < 0) {
                this.y = 0;
            }
            this.row = this.y / this.cellHeight;
            if (this.row >= this.rowCount) {
                this.row = this.rowCount - 1;
            }
            this.scrollPos = n2;
            this.repaint();
        }

        public void paintComponent(Graphics graphics) {
            Component component;
            int n = Math.min(this.stateTable.getHeight(), this.stateTable.getParent().getHeight());
            graphics.setClip(this.p.x, this.yOffset, this.cellWidth, n);
            for (int i = 0; i < this.rowCount; ++i) {
                Object object = null;
                object = i > this.row && i <= this.orgRow ? this.stateTable.getValueAt(i - 1, 0) : (i < this.row && i >= this.orgRow ? this.stateTable.getValueAt(i + 1, 0) : (i == this.row ? "" : this.stateTable.getValueAt(i, 0)));
                component = this.renderer.getTableCellRendererComponent(this.stateTable, object, false, false, i, 0);
                component.setSize(this.cellWidth, this.cellHeight);
                ((JComponent)component).setBorder(BorderFactory.createLineBorder(component.getBackground().darker()));
                SwingUtilities.paintComponent(graphics, component, this, this.p.x, i * this.cellHeight + this.yOffset - this.scrollPos, this.cellWidth, this.cellHeight);
            }
            component = this.renderer.getTableCellRendererComponent(this.stateTable, this.stateTable.getValueAt(this.orgRow, 0), false, false, this.orgRow, 0);
            Color color = component.getBackground();
            component.setBackground(Color.white);
            int n2 = Math.max(this.yOffset, Math.min(this.y + this.yOffset - this.orgY % this.cellHeight, this.yOffset + this.stateTable.getHeight() - this.cellHeight));
            SwingUtilities.paintComponent(graphics, component, this, this.p.x, n2 - this.scrollPos, this.cellWidth, this.cellHeight);
            component.setBackground(color);
        }
    }

    protected class ResizeStateTableListener
    extends MouseAdapter
    implements MouseMotionListener {
        boolean caughtEdge = false;
        boolean resized = false;
        Cursor resizeCursor;
        Cursor standard;
        private int minimumWidth = 50;

        public ResizeStateTableListener() {
            NodeTable.this.isStateResizing(false);
            this.resizeCursor = new Cursor(11);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (Math.abs(mouseEvent.getX() - NodeTable.this.stateTable.getWidth()) < 5) {
                this.standard = NodeTable.this.stateTable.getCursor();
                NodeTable.this.setCursor(this.resizeCursor);
                this.caughtEdge = true;
            } else {
                NodeTable.this.setCursor(null);
                this.caughtEdge = false;
            }
            NodeTable.this.isStateResizing(this.caughtEdge);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.caughtEdge && mouseEvent.getX() != NodeTable.this.stateTable.getWidth() && mouseEvent.getX() >= this.minimumWidth) {
                NodeTable.this.stateTable.setColumnWidth(mouseEvent.getX());
                NodeTable.this.stateTableView.setPreferredSize(new Dimension(mouseEvent.getX(), NodeTable.this.stateTableView.getHeight()));
                NodeTable.this.stateTableView.revalidate();
                NodeTable.this.headerPanel.revalidate();
                NodeTable.this.fireStateTableResized();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.resized) {
                NodeTable.this.resizeTable();
                NodeTable.this.revalidate();
                NodeTable.this.fireStateTableResized();
            }
            this.resized = false;
            NodeTable.this.isStateResizing(false);
        }
    }

    protected class EndResizeStateTableListener
    implements MouseMotionListener {
        protected EndResizeStateTableListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            NodeTable.this.setCursor(null);
            NodeTable.this.isStateResizing(false);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            NodeTable.this.setCursor(null);
            NodeTable.this.isStateResizing(false);
        }
    }

    protected class StateDragListener
    implements EventListener {
        protected StateDragListener() {
        }

        public void stateDrag(int n, int n2, int n3) {
        }

        public void endDrag(int n) {
        }
    }
}

