/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.UncertainEdge;
import COM.hugin.HGUI.CertainUndirectedLink;
import COM.hugin.HGUI.HelpPanel;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIEventHandler;
import COM.hugin.HGUI.HuginInsets;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.Link;
import COM.hugin.HGUI.Node;
import COM.hugin.HGUI.PronelDecisionAction;
import COM.hugin.HGUI.PronelDirectionAction;
import COM.hugin.HGUI.PronelPanel;
import COM.hugin.HGUI.ScrollButtons;
import COM.hugin.HGUI.UncertainLink;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JToolTip;

public class PronelContainer
extends JPanel {
    HuginProjectFrame project;
    PronelPanel networkPanel;
    Domain domain;
    JButton netProp;
    JButton printNet;
    JButton directForward;
    JButton directBackward;
    JButton include;
    JButton exclude;
    JButton undo;
    JButton ok;
    JButton help;
    HelpPanel helpPanel;
    static ImageIcon linkE = new ImageIcon(ClassLoader.getSystemResource("icons/pronelE.gif"));
    static ImageIcon linkW = new ImageIcon(ClassLoader.getSystemResource("icons/pronelW.gif"));
    static ImageIcon linkN = new ImageIcon(ClassLoader.getSystemResource("icons/pronelN.gif"));
    static ImageIcon linkS = new ImageIcon(ClassLoader.getSystemResource("icons/pronelS.gif"));
    static ImageIcon linkNE = new ImageIcon(ClassLoader.getSystemResource("icons/pronelNE.gif"));
    static ImageIcon linkNW = new ImageIcon(ClassLoader.getSystemResource("icons/pronelNW.gif"));
    static ImageIcon linkSW = new ImageIcon(ClassLoader.getSystemResource("icons/pronelSW.gif"));
    static ImageIcon linkSE = new ImageIcon(ClassLoader.getSystemResource("icons/pronelSE.gif"));
    JScrollPane pane;
    private static final int E = 1;
    private static final int NE = 2;
    private static final int N = 3;
    private static final int NW = 4;
    private static final int W = 5;

    public PronelContainer(HuginProjectFrame huginProjectFrame, Domain domain) {
        this.project = huginProjectFrame;
        try {
            this.domain = domain;
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
        this.networkPanel = new PronelPanel(this);
        this.networkPanel.addLinkSelectionChangeListener(new ButtonUpdater());
        this.networkPanel.addActionPerformedListener(new ActionPerformed());
        this.helpPanel = new HelpPanel(Hugin.mainFrame);
        this.setLayout(new BorderLayout());
        this.pane = new JScrollPane(this.networkPanel);
        this.pane.getViewport().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                PronelContainer.this.networkPanel.repaint();
            }
        });
        this.add((Component)this.pane, "Center");
        this.netProp = new JButton(new HuginGUIEventHandler.MENU_NETWORK_Network_PropertiesAction(huginProjectFrame));
        this.netProp.setText("");
        this.printNet = new JButton(new HuginGUIEventHandler.MENU_FILE_Print_NetworkAction());
        this.printNet.setText("");
        this.printNet.setMargin(new HuginInsets());
        this.include = new JButton(new PronelDecisionAction(this.networkPanel, UncertainEdge.H_EDGE_DECISION_INCLUDE, new ImageIcon(ClassLoader.getSystemResource("icons/includePronel.gif"))));
        this.include.setMargin(new HuginInsets());
        this.include.setToolTipText(HuginGUIConstants.get("str_include_link"));
        this.exclude = new JButton(new PronelDecisionAction(this.networkPanel, UncertainEdge.H_EDGE_DECISION_EXCLUDE, new ImageIcon(ClassLoader.getSystemResource("icons/excludePronel.gif"))));
        this.exclude.setMargin(new HuginInsets());
        this.exclude.setToolTipText(HuginGUIConstants.get("str_exclude_link"));
        this.undo = new JButton(new ImageIcon(ClassLoader.getSystemResource("icons/undo.gif")));
        this.undo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PronelContainer.this.networkPanel.getDomain().undoManualDecisions();
                    PronelContainer.this.networkPanel.rebuildPronel();
                    PronelContainer.this.networkPanel.getUndoQueue().undo();
                    PronelContainer.this.networkPanel.rebuildPronel();
                    PronelContainer.this.reportModelSize();
                }
                catch (Exception exception) {
                    new HuginGUIError(exception.getMessage());
                    PronelContainer.this.networkPanel.rebuildPronel();
                }
                PronelContainer.this.networkPanel.repaint();
                PronelContainer.this.undo.setEnabled(PronelContainer.this.networkPanel.getUndoQueue().canUndo());
            }
        });
        this.undo.setMargin(new HuginInsets());
        this.undo.setToolTipText(HuginGUIConstants.get("str_undo"));
        this.directForward = new JButton(new PronelDirectionAction(this.networkPanel, 0, linkSW)){

            public String getToolTipText(MouseEvent mouseEvent) {
                Link link;
                Link link2 = link = PronelContainer.this.networkPanel.selectedLinks.size() == 1 ? (Link)PronelContainer.this.networkPanel.selectedLinks.getFirst() : null;
                if (link instanceof CertainUndirectedLink) {
                    return link.parent + "->" + link.child;
                }
                return HuginGUIConstants.get("str_direct_forward");
            }

            public Point getToolTipLocation(MouseEvent mouseEvent) {
                Link link;
                Link link2 = link = PronelContainer.this.networkPanel.selectedLinks.size() == 1 ? (Link)PronelContainer.this.networkPanel.selectedLinks.getFirst() : null;
                if (!(link instanceof CertainUndirectedLink)) {
                    return super.getToolTipLocation(mouseEvent);
                }
                JToolTip jToolTip = this.createToolTip();
                jToolTip.setTipText(this.getToolTipText(mouseEvent));
                return new Point((this.getWidth() - jToolTip.getPreferredSize().width) / 2, this.getHeight());
            }
        };
        this.directForward.setToolTipText("This registers the button as having a tooltip");
        this.directForward.setMargin(new HuginInsets());
        this.directBackward = new JButton(new PronelDirectionAction(this.networkPanel, 1, linkNE)){

            public String getToolTipText(MouseEvent mouseEvent) {
                Link link;
                Link link2 = link = PronelContainer.this.networkPanel.selectedLinks.size() == 1 ? (Link)PronelContainer.this.networkPanel.selectedLinks.getFirst() : null;
                if (link instanceof CertainUndirectedLink) {
                    return link.child + "->" + link.parent;
                }
                return HuginGUIConstants.get("str_direct_backward");
            }

            public Point getToolTipLocation(MouseEvent mouseEvent) {
                Link link;
                Link link2 = link = PronelContainer.this.networkPanel.selectedLinks.size() == 1 ? (Link)PronelContainer.this.networkPanel.selectedLinks.getFirst() : null;
                if (!(link instanceof CertainUndirectedLink)) {
                    return super.getToolTipLocation(mouseEvent);
                }
                JToolTip jToolTip = this.createToolTip();
                jToolTip.setTipText(this.getToolTipText(mouseEvent));
                return new Point((this.getWidth() - jToolTip.getPreferredSize().width) / 2, this.getHeight());
            }
        };
        this.directBackward.setToolTipText("This registers the button as having a tooltip");
        this.directBackward.setMargin(new HuginInsets());
        this.ok = new JButton(HuginGUIConstants.get("str_done"));
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PronelContainer.this.reportModelSize();
                    Domain domain = PronelContainer.this.domain;
                    domain.decideAutomatically();
                    PronelContainer.this.project.removePronelPanel(domain);
                }
                catch (Exception exception) {
                    new HuginGUIError(exception);
                }
            }
        });
        this.help = new JButton(HuginGUIConstants.get("str_help"));
        this.help.addActionListener(new HelpListener("help/structuralUncertaintiesHelp.html"));
        this.include.setEnabled(false);
        this.exclude.setEnabled(false);
        this.directForward.setEnabled(false);
        this.directBackward.setEnabled(false);
        this.undo.setEnabled(false);
        JToolBar jToolBar = new JToolBar();
        jToolBar.add(this.printNet);
        jToolBar.addSeparator(new Dimension(10, 0));
        jToolBar.add(this.include);
        jToolBar.add(this.exclude);
        jToolBar.add(this.directForward);
        jToolBar.add(this.directBackward);
        jToolBar.addSeparator(new Dimension(10, 0));
        jToolBar.add(this.undo);
        jToolBar.add(Box.createHorizontalGlue());
        jToolBar.add(this.ok);
        jToolBar.add(this.help);
        jToolBar.setFloatable(false);
        ScrollButtons scrollButtons = new ScrollButtons(jToolBar);
        this.add((Component)scrollButtons, "North");
        this.reportModelSize();
    }

    protected Domain getDomain() {
        return this.domain;
    }

    protected JScrollPane getNetworkScroller() {
        return this.pane;
    }

    protected PronelPanel getPanel() {
        return this.networkPanel;
    }

    protected JButton getPrintNetButton() {
        return this.printNet;
    }

    private void assignIconsToDirectButtons(Link link) {
        DirectButtonImages directButtonImages = PronelContainer.getDirectButtonImages(link);
        this.directForward.setIcon(directButtonImages.forwardImage);
        this.directBackward.setIcon(directButtonImages.backwardImage);
    }

    protected static DirectButtonImages getDirectButtonImages(Link link) {
        Node node = link.child.y > link.parent.y ? link.child : link.parent;
        Node node2 = link.child.equals(node) ? link.parent : link.child;
        double d = node2.x - node.x;
        double d2 = node2.y - node.y;
        double d3 = Math.acos(d / Math.sqrt(d * d + d2 * d2));
        double d4 = Math.PI;
        int n = 0;
        if (d3 < d4 / 18.0) {
            n = 1;
        }
        if (d3 >= d4 / 18.0 && d3 <= 20.0 * d4 / 45.0) {
            n = 2;
        }
        if (d3 > 20.0 * d4 / 45.0 && d3 < 25.0 * d4 / 45.0) {
            n = 3;
        }
        if (d3 >= 25.0 * d4 / 45.0 && d3 <= 17.0 * d4 / 18.0) {
            n = 4;
        }
        if (d3 > 17.0 * d4 / 18.0) {
            n = 5;
        }
        boolean bl = link.parent.equals(node);
        DirectButtonImages directButtonImages = new DirectButtonImages();
        switch (n) {
            case 1: {
                directButtonImages.forwardImage = bl ? linkE : linkW;
                directButtonImages.backwardImage = bl ? linkW : linkE;
                break;
            }
            case 2: {
                directButtonImages.forwardImage = bl ? linkNE : linkSW;
                directButtonImages.backwardImage = bl ? linkSW : linkNE;
                break;
            }
            case 3: {
                directButtonImages.forwardImage = bl ? linkN : linkS;
                directButtonImages.backwardImage = bl ? linkS : linkN;
                break;
            }
            case 4: {
                directButtonImages.forwardImage = bl ? linkNW : linkSE;
                directButtonImages.backwardImage = bl ? linkSE : linkNW;
                break;
            }
            case 5: {
                directButtonImages.forwardImage = bl ? linkW : linkE;
                directButtonImages.backwardImage = bl ? linkE : linkW;
                break;
            }
            default: {
                new HuginGUIError("PronelContainer.assignIconsToDirectButtons()", HuginGUIConstants.get("str_internal_error_please_report"));
            }
        }
        return directButtonImages;
    }

    private void reportModelSize() {
        Hugin.mainFrame.statusBar.write(HuginGUIConstants.get("str_model_size_") + this.networkPanel.getModelSize());
    }

    public static class DirectButtonImages {
        ImageIcon forwardImage;
        ImageIcon backwardImage;
    }

    private class ActionPerformed
    implements PronelPanel.ActionPerformedListener {
        private ActionPerformed() {
        }

        public void actionPerformed() {
            PronelContainer.this.exclude.setEnabled(false);
            PronelContainer.this.include.setEnabled(false);
            PronelContainer.this.directForward.setEnabled(false);
            PronelContainer.this.directBackward.setEnabled(false);
            PronelContainer.this.undo.setEnabled(PronelContainer.this.networkPanel.getUndoQueue().canUndo());
            PronelContainer.this.reportModelSize();
        }
    }

    private class ButtonUpdater
    implements PronelPanel.LinkSelectionChangeListener {
        private ButtonUpdater() {
        }

        public void linkSelectionChanged(Link link) {
            boolean bl = link instanceof UncertainLink;
            boolean bl2 = link instanceof CertainUndirectedLink;
            PronelContainer.this.exclude.setEnabled(bl);
            PronelContainer.this.include.setEnabled(bl);
            PronelContainer.this.directForward.setEnabled(bl2);
            PronelContainer.this.directBackward.setEnabled(bl2);
            if (bl2) {
                PronelContainer.this.assignIconsToDirectButtons(link);
            }
        }
    }

    private class HelpListener
    implements ActionListener {
        String helpPage;

        public HelpListener(String string) {
            this.helpPage = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PronelContainer.this.helpPanel.setHelpPage(this.helpPage);
            if (!PronelContainer.this.helpPanel.isVisible()) {
                PronelContainer.this.helpPanel.setLocation(50, 50);
                PronelContainer.this.helpPanel.setVisible(true);
            }
        }
    }
}

