/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.ExceptionUsage;
import COM.hugin.HAPI.LabelledDCNode;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NodeList;
import COM.hugin.HGUI.CaseFileViewer;
import COM.hugin.HGUI.DataSourceException;
import COM.hugin.HGUI.DataStream;
import COM.hugin.HGUI.HelpPanel;
import COM.hugin.HGUI.Hugin;
import COM.hugin.HGUI.HuginFileLoader;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import COM.hugin.HGUI.HuginGUIFrame;
import COM.hugin.HGUI.HuginGUIUtils;
import COM.hugin.HGUI.HuginProjectFrame;
import COM.hugin.HGUI.LearningWizard;
import COM.hugin.HGUI.NetworkNamingPane;
import COM.hugin.HGUI.PastingTextField;
import COM.hugin.HGUI.TextfileDataSource;
import COM.hugin.HGUI.TitledPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Hashtable;
import java.util.SortedMap;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;

public class StructuralLearningSetupPane
extends JDialog {
    JDialog owner;
    StructuralLearningSetupPane self = this;
    PastingTextField significanceLevel;
    Domain domain;
    JButton view_data;
    JButton ok;
    HelpPanel helpPanel;
    File file;
    HuginGUIFrame frame;
    HuginProjectFrame project = null;
    String className;
    String fileName;
    String logFileName;
    JLabel fileNameLabel;
    private int selectedLearningAlgorithm = 2;
    SortedMap<String, Charset> charsets;
    JComboBox encodingBox;
    JLabel encodingLabel;
    JButton defaultButton;
    private Hashtable<String, Integer> nodeStateMapping;
    boolean manyStatesConfirmed = false;

    public StructuralLearningSetupPane(HuginGUIFrame huginGUIFrame) {
        super(huginGUIFrame, HuginGUIConstants.get("StructuralLearning"), true);
        this.frame = huginGUIFrame;
        try {
            TitledPanel titledPanel = new TitledPanel(HuginGUIConstants.get("StructuralLearning_parameters_for_learning"));
            JPanel jPanel = new JPanel(new GridLayout(3, 2, 5, 5));
            jPanel.add(new JLabel(HuginGUIConstants.get("StructuralLearning_data_file")));
            this.fileNameLabel = new JLabel(this.fileName);
            jPanel.add(this.fileNameLabel);
            this.significanceLevel = new PastingTextField("0.05");
            this.significanceLevel.setHorizontalAlignment(4);
            jPanel.add(new JLabel(HuginGUIConstants.get("StructuralLearning_level_of_significance")));
            jPanel.add(this.significanceLevel);
            jPanel.add(new JLabel(HuginGUIConstants.get("StructuralLearning_algorithms")));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            ButtonGroup buttonGroup = new ButtonGroup();
            JRadioButton jRadioButton = new JRadioButton(HuginGUIConstants.get("PC_LABEL"), this.selectedLearningAlgorithm == 1);
            JRadioButton jRadioButton2 = new JRadioButton(HuginGUIConstants.get("NPC_LABEL"), this.selectedLearningAlgorithm == 2);
            jRadioButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    StructuralLearningSetupPane.this.selectedLearningAlgorithm = 1;
                }
            });
            jRadioButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    StructuralLearningSetupPane.this.selectedLearningAlgorithm = 2;
                }
            });
            buttonGroup.add(jRadioButton);
            buttonGroup.add(jRadioButton2);
            jPanel2.add(jRadioButton2);
            jPanel2.add(jRadioButton);
            jPanel.add(jPanel2);
            JPanel jPanel3 = new JPanel(new BorderLayout(5, 5));
            JPanel jPanel4 = new JPanel(new FlowLayout(1, 5, 5));
            JPanel jPanel5 = new JPanel(new FlowLayout(1, 5, 5));
            this.view_data = new JButton(HuginGUIConstants.get("EMLearning_view_data"));
            this.view_data.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JDialog jDialog = new JDialog(StructuralLearningSetupPane.this.self, HuginGUIConstants.get("str_case_view"), true);
                    CaseFileViewer caseFileViewer = new CaseFileViewer(jDialog, StructuralLearningSetupPane.this.domain);
                    jDialog.setContentPane(caseFileViewer);
                    jDialog.pack();
                    jDialog.setLocation(StructuralLearningSetupPane.this.self.getX() + 100, StructuralLearningSetupPane.this.self.getY() + 50);
                    jDialog.setVisible(true);
                }
            });
            this.helpPanel = new HelpPanel(Hugin.mainFrame);
            JButton jButton = new JButton(HuginGUIConstants.get("EMLearning_help"));
            jButton.addActionListener(new HelpListener("help/structuralLearningHelp.html"));
            final HuginFileLoader huginFileLoader = new HuginFileLoader(1, Hugin.mainFrame.getMostRecentDataFile(), 0);
            JButton jButton2 = new JButton(HuginGUIConstants.get("EMLearning_select_file"));
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    block7: {
                        huginFileLoader.setLocation(100, 100);
                        int n = huginFileLoader.showDialog(StructuralLearningSetupPane.this.self);
                        if (n == 0) {
                            StructuralLearningSetupPane.this.file = huginFileLoader.getSelectedFile();
                            if (StructuralLearningSetupPane.this.file.exists()) {
                                try {
                                    StructuralLearningSetupPane.this.domain = new Domain();
                                    StructuralLearningSetupPane.this.fileName = StructuralLearningSetupPane.this.file.getName();
                                    StructuralLearningSetupPane.this.fileNameLabel.setText(StructuralLearningSetupPane.this.fileName);
                                    StructuralLearningSetupPane.this.className = NetworkNamingPane.legalize(StructuralLearningSetupPane.getRootName(StructuralLearningSetupPane.this.fileName));
                                    StructuralLearningSetupPane.this.logFileName = Hugin.mainFrame.getLogFileDir() + StructuralLearningSetupPane.this.className + ".hlg";
                                    StructuralLearningSetupPane.this.domain.openLogFile(StructuralLearningSetupPane.this.logFileName);
                                    try {
                                        DataStream dataStream = new DataStream(new TextfileDataSource(StructuralLearningSetupPane.this.file.getPath(), null, StructuralLearningSetupPane.this.getEncoding()), StructuralLearningSetupPane.this.domain, true);
                                        HuginGUIUtils.insertCases(dataStream, true);
                                        StructuralLearningSetupPane.this.view_data.setEnabled(true);
                                        StructuralLearningSetupPane.this.ok.setEnabled(true);
                                        StructuralLearningSetupPane.this.getRootPane().setDefaultButton(StructuralLearningSetupPane.this.ok);
                                        Hugin.mainFrame.setMostRecentDataFile(StructuralLearningSetupPane.this.file);
                                        break block7;
                                    }
                                    catch (Exception exception) {
                                        StructuralLearningSetupPane.this.domain.delete();
                                        throw exception;
                                    }
                                }
                                catch (DataSourceException dataSourceException) {
                                    new HuginGUIError(dataSourceException.getMessage());
                                    return;
                                }
                                catch (Exception exception) {
                                    new HuginGUIError(exception);
                                    return;
                                }
                            }
                            new HuginGUIError(HuginGUIConstants.get("StructuralLearning_invalid_file"));
                        }
                    }
                }
            });
            this.ok = new JButton(HuginGUIConstants.get("OK_button"));
            this.ok.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        double d = new Double(StructuralLearningSetupPane.this.significanceLevel.getText());
                        if (d < 0.0) {
                            new HuginGUIError(HuginGUIConstants.get("EMLearning_bad_number_value"));
                            return;
                        }
                        StructuralLearningSetupPane.this.domain.setSignificanceLevel(d);
                        HuginGUIUtils.performNodeTyping(StructuralLearningSetupPane.this.domain, null);
                        switch (StructuralLearningSetupPane.this.selectedLearningAlgorithm) {
                            case 2: {
                                StructuralLearningSetupPane.this.domain.learnStructureNPC();
                                StructuralLearningSetupPane.this.project = StructuralLearningSetupPane.this.frame.createProjectForStructuralLearning(false);
                                if (LearningWizard.unresolvedLinks(StructuralLearningSetupPane.this.domain)) {
                                    StructuralLearningSetupPane.this.project.installPronelPanel(StructuralLearningSetupPane.this.domain, StructuralLearningSetupPane.this.className, StructuralLearningSetupPane.this.logFileName);
                                    break;
                                }
                                StructuralLearningSetupPane.this.domain.decideAutomatically();
                                StructuralLearningSetupPane.this.project.loadNet(Hugin.mainFrame.cc.addDomain(StructuralLearningSetupPane.this.domain, StructuralLearningSetupPane.this.className), StructuralLearningSetupPane.this.logFileName);
                                break;
                            }
                            case 1: {
                                StructuralLearningSetupPane.this.domain.learnStructure();
                                StructuralLearningSetupPane.this.project = StructuralLearningSetupPane.this.frame.createProjectForStructuralLearning(false);
                                StructuralLearningSetupPane.this.project.loadNet(Hugin.mainFrame.cc.addDomain(StructuralLearningSetupPane.this.domain, StructuralLearningSetupPane.this.className), StructuralLearningSetupPane.this.logFileName);
                                break;
                            }
                            default: {
                                new HuginGUIError("StructuralLearningSetupPane.init()", HuginGUIConstants.get("str_unknown_algorithm"));
                            }
                        }
                        StructuralLearningSetupPane.this.self.dispose();
                    }
                    catch (NumberFormatException numberFormatException) {
                        new HuginGUIError(HuginGUIConstants.get("EMLearning_bad_number_value"));
                    }
                    catch (ExceptionUsage exceptionUsage) {
                        new HuginGUIError(HuginGUIConstants.get("str_unable_to_run_alg_please_try_to_run_another_alg"));
                    }
                    catch (ExceptionHugin exceptionHugin) {
                        new HuginGUIError(exceptionHugin.getMessage());
                        try {
                            if (StructuralLearningSetupPane.this.project != null) {
                                StructuralLearningSetupPane.this.project.doCloseWindow();
                            }
                        }
                        catch (Exception exception) {
                            new HuginGUIError(exception);
                        }
                    }
                }
            });
            JButton jButton3 = new JButton(HuginGUIConstants.get("cancel_button"));
            jButton3.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        if (StructuralLearningSetupPane.this.project != null) {
                            StructuralLearningSetupPane.this.project.doCloseWindow();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    StructuralLearningSetupPane.this.self.dispose();
                }
            });
            this.view_data.setEnabled(false);
            this.ok.setEnabled(false);
            jPanel4.add(jButton2);
            jPanel4.add(this.view_data);
            jPanel4.add(jButton);
            jPanel5.add(this.ok);
            jPanel5.add(jButton3);
            jPanel3.add((Component)this.getEncodingPanel(), "North");
            jPanel3.add((Component)jPanel4, "Center");
            jPanel3.add((Component)jPanel5, "South");
            titledPanel.setLayout(new BorderLayout(0, 5));
            titledPanel.add((Component)jPanel, "Center");
            titledPanel.add((Component)jPanel3, "South");
            this.getContentPane().setLayout(new BorderLayout(0, 5));
            this.getContentPane().add((Component)titledPanel, "Center");
            this.getRootPane().setDefaultButton(jButton2);
            if (System.getProperty("os.name").equals("Linux")) {
                this.setSize((int)this.getPreferredSize().getWidth() + 10, (int)this.getPreferredSize().getHeight() + 30);
            }
            this.setResizable(false);
        }
        catch (Exception exception) {
            new HuginGUIError(exception.getMessage());
        }
    }

    private JPanel getEncodingPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        this.charsets = Charset.availableCharsets();
        Collection<Charset> collection = this.charsets.values();
        this.encodingBox = new JComboBox<Object>(collection.toArray());
        if (this.charsets.containsKey("UTF-8")) {
            this.encodingBox.setSelectedItem(this.charsets.get("UTF-8"));
        }
        this.encodingLabel = new JLabel(HuginGUIConstants.get("LW_encoding"));
        this.defaultButton = new JButton(HuginGUIConstants.get("LW_set_to_default"));
        this.defaultButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (StructuralLearningSetupPane.this.charsets.containsKey("UTF-8")) {
                    StructuralLearningSetupPane.this.encodingBox.setSelectedItem(StructuralLearningSetupPane.this.charsets.get("UTF-8"));
                }
            }
        });
        jPanel.add((Component)this.encodingLabel, "West");
        jPanel.add((Component)this.encodingBox, "Center");
        jPanel.add((Component)this.defaultButton, "East");
        jPanel.add((Component)new JSeparator(), "South");
        return jPanel;
    }

    public String getEncoding() {
        return this.encodingBox.getSelectedItem().toString();
    }

    private static String getRootName(String string) {
        String string2;
        int n = string.lastIndexOf(".");
        if (n > 0 && (string2 = string.substring(n + 1)).equals("dat")) {
            return string.substring(0, n);
        }
        return string;
    }

    private boolean insertCases(Domain domain, File file) {
        this.nodeStateMapping = new Hashtable();
        Vector<LabelledDCNode> vector = new Vector<LabelledDCNode>();
        try {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            domain.setNumberOfCases(0);
            String string = bufferedReader.readLine();
            String[] stringArray = this.split(string, ",");
            if (stringArray == null) {
                new HuginGUIError(HuginGUIConstants.get("StructuralLearning_maybe_empty_file"));
                return false;
            }
            for (n = 0; n < stringArray.length; ++n) {
                LabelledDCNode labelledDCNode = new LabelledDCNode(domain);
                labelledDCNode.setName(stringArray[n]);
                vector.add(labelledDCNode);
            }
            string = bufferedReader.readLine();
            n = vector.size();
            while (string != null) {
                if (string.trim().length() > 0) {
                    int n2 = domain.newCase();
                    stringArray = this.split(string, ",");
                    if (stringArray == null) {
                        new HuginGUIError(HuginGUIConstants.get("StructuralLearning_maybe_empty_file"));
                        this.nodeStateMapping = null;
                        return false;
                    }
                    if (stringArray.length > n) {
                        new HuginGUIError(HuginGUIConstants.get("StructuralLearning_invalid_data"));
                        this.nodeStateMapping = null;
                        return false;
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        LabelledDCNode labelledDCNode = (LabelledDCNode)vector.get(i);
                        if (this.insertNodeCase(labelledDCNode, stringArray[i], n2)) continue;
                        this.nodeStateMapping = null;
                        return false;
                    }
                }
                string = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception.getMessage());
            this.nodeStateMapping = null;
            return false;
        }
        this.nodeStateMapping = null;
        return true;
    }

    private boolean insertNodeCase(LabelledDCNode labelledDCNode, String string, int n) {
        if (string.equals("N/A")) {
            return true;
        }
        try {
            int n2 = labelledDCNode.getNumberOfStates();
            Integer n3 = this.nodeStateMapping.get(labelledDCNode.getName() + string);
            if (n3 != null) {
                labelledDCNode.setCaseState(n, n3);
                return true;
            }
            if (n2 == 1 && labelledDCNode.getStateLabel(0).equals("")) {
                labelledDCNode.setStateLabel(0, string);
                this.nodeStateMapping.put(labelledDCNode.getName() + string, new Integer(0));
            } else {
                if (++n2 > 50 && !this.manyStatesConfirmed && !(this.manyStatesConfirmed = this.confirmManyStates())) {
                    return false;
                }
                labelledDCNode.setNumberOfStates(n2);
                labelledDCNode.setStateLabel(n2 - 1, string);
                this.nodeStateMapping.put(labelledDCNode.getName() + string, new Integer(n2 - 1));
            }
            labelledDCNode.setCaseState(n, n2 - 1);
            return true;
        }
        catch (Exception exception) {
            new HuginGUIError(exception.getMessage());
            return false;
        }
    }

    private boolean confirmManyStates() {
        int n = JOptionPane.showConfirmDialog(this, "Your data indicates that there are variables with more than 50 states.\nThis could indicate that the dataset contains continuous variables.\nStructure learning with continuous variables is not supported in Hugin.\n\nDo you wish to continue?", HuginGUIConstants.get("StructuralLearning_confirm_many_states"), 0);
        return n == 0;
    }

    private void simplePlaceNodes(Domain domain) {
        int n = 2 * this.frame.preferences.node_width;
        int n2 = 2 * this.frame.preferences.node_height;
        try {
            NodeList nodeList = domain.getNodes();
            int n3 = (int)Math.sqrt(nodeList.size()) + 1;
            int n4 = 1;
            int n5 = 1;
            for (Node node : nodeList) {
                node.setPosition(new Point2D.Double(n4 * n - n / 2, n5 * n2 - n2 / 2));
                if (++n4 <= n3) continue;
                n4 = 1;
                ++n5;
            }
        }
        catch (Exception exception) {
            new HuginGUIError(exception);
        }
    }

    private String[] split(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        if (string == null) {
            return null;
        }
        int n2 = string.indexOf(string2);
        while (n2 >= 0 && n2 < 10000) {
            vector.add(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf(string2, n);
        }
        vector.add(string.substring(n));
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((String)vector.get(i)).trim();
        }
        return stringArray;
    }

    private class HelpListener
    implements ActionListener {
        String helpPage;

        public HelpListener(String string) {
            this.helpPage = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StructuralLearningSetupPane.this.helpPanel.setHelpPage(this.helpPage);
            if (!StructuralLearningSetupPane.this.helpPanel.isVisible()) {
                StructuralLearningSetupPane.this.helpPanel.setLocation(50, 50);
                StructuralLearningSetupPane.this.helpPanel.setVisible(true);
            }
        }
    }
}

