/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.NetworkModel;
import COM.hugin.HGUI.DataSource;
import COM.hugin.HGUI.DataSourceException;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.HuginGUIError;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;

public class TextfileDataSource
implements DataSource {
    private File file;
    private long lineNumber;
    private BufferedReader in;
    private String separators;
    private boolean readNames = true;
    private int fields;
    private int[] fieldReOrder;
    private String[] fieldNames = null;
    private static final char comment = '%';
    public static final String defaultEncoding = "UTF-8";
    private String encoding = "UTF-8";

    public TextfileDataSource(String string) throws FileNotFoundException {
        this.file = new File(string);
        this.lineNumber = 0L;
        if (!this.file.exists()) {
            throw new FileNotFoundException(HuginGUIConstants.get("str_file_") + string + HuginGUIConstants.get("str__not_found"));
        }
        try {
            this.in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), this.encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            new HuginGUIError(unsupportedEncodingException.getMessage() + HuginGUIConstants.get("str_lb_lb_using_default_encoding"));
            this.in = new BufferedReader(new FileReader(this.file));
        }
        this.separators = ",;:\t";
        this.configureFields();
    }

    public TextfileDataSource(String string, String string2, String string3) throws FileNotFoundException {
        this.file = new File(string);
        this.encoding = string3;
        this.lineNumber = 0L;
        if (!this.file.exists()) {
            throw new FileNotFoundException(HuginGUIConstants.get("str_file_") + string + HuginGUIConstants.get("str__not_found"));
        }
        try {
            this.in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), string3));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            new HuginGUIError(unsupportedEncodingException.getMessage() + HuginGUIConstants.get("str_lb_lb_using_default_encoding"));
            this.in = new BufferedReader(new FileReader(this.file));
        }
        this.separators = string2 != null && string2.length() > 0 ? string2 : ",;:\t";
        this.configureFields();
    }

    public TextfileDataSource(String string, String string2) throws FileNotFoundException {
        this(string);
        this.separators = this.separators;
    }

    public TextfileDataSource(File file) throws FileNotFoundException {
        this.file = file;
        this.lineNumber = 0L;
        if (!file.exists()) {
            throw new FileNotFoundException(HuginGUIConstants.get("str_file_") + file.getName() + HuginGUIConstants.get("str__not_found"));
        }
        try {
            this.in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), this.encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            new HuginGUIError(unsupportedEncodingException.getMessage() + HuginGUIConstants.get("str_lb_lb_using_default_encoding"));
            this.in = new BufferedReader(new FileReader(this.file));
        }
        this.separators = ",";
        this.configureFields();
    }

    public TextfileDataSource(File file, String string) throws FileNotFoundException {
        this(file);
        this.separators = string;
    }

    private void configureFields() {
        try {
            this.in.mark(10000);
            String string = this.in.readLine();
            this.in.reset();
            if (string != null) {
                int n;
                String string2 = string.trim();
                String[] stringArray = string.split("[" + this.separators + "]");
                this.fields = stringArray.length;
                this.fieldReOrder = new int[this.fields];
                ArrayList<String> arrayList = new ArrayList<String>();
                for (n = 0; n < stringArray.length; ++n) {
                    stringArray[n] = stringArray[n].trim();
                    arrayList.add(stringArray[n]);
                }
                Collections.sort(arrayList);
                for (n = 0; n < stringArray.length; ++n) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        if (!stringArray[n].equals((String)arrayList.get(i))) continue;
                        this.fieldReOrder[n] = i;
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setSeparators(String string) {
        this.separators = string;
    }

    public String getSeparator() {
        return this.separators;
    }

    public void readNamesFromFile(boolean bl) {
        this.readNames = bl;
    }

    public String[] readLine() throws DataSourceException {
        try {
            String string = this.in.readLine();
            if (string == null) {
                return null;
            }
            String string2 = string.trim();
            if (string2.length() == 0) {
                return new String[0];
            }
            if (string2.charAt(0) == '%') {
                return new String[0];
            }
            String[] stringArray = string.split("[" + this.separators + "]");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
                if (stringArray[i].startsWith("\"") && stringArray[i].endsWith("\"") && stringArray[i].length() > 2) {
                    stringArray[i] = stringArray[i].substring(1, stringArray[i].length() - 1);
                }
                if (!stringArray[i].contains("\\")) continue;
                try {
                    stringArray[i] = NetworkModel.removeEscapeSequences(stringArray[i]);
                    continue;
                }
                catch (ExceptionHugin exceptionHugin) {
                    // empty catch block
                }
            }
            if (stringArray.length < this.fields) {
                String[] stringArray2 = new String[this.fields];
                for (int i = 0; i < this.fields; ++i) {
                    stringArray2[i] = i < stringArray.length ? stringArray[i] : "";
                }
                stringArray = stringArray2;
            }
            String[] stringArray3 = new String[this.fields];
            for (int i = 0; i < this.fields; ++i) {
                stringArray3[this.fieldReOrder[i]] = stringArray[i];
            }
            ++this.lineNumber;
            return stringArray3;
        }
        catch (IOException iOException) {
            throw new DataSourceException(iOException.getMessage());
        }
    }

    public String[] getNames() throws DataSourceException {
        if (this.fieldNames != null) {
            return this.fieldNames;
        }
        if (this.getLineNumber() > 0L) {
            throw new DataSourceException(HuginGUIConstants.get("str_unable_to_read_names_after_readline_has_been_called"));
        }
        if (this.readNames) {
            return this.readLine();
        }
        int n = this.readLine().length;
        this.reset();
        this.fieldNames = new String[n];
        for (int i = 0; i < n; ++i) {
            this.fieldNames[i] = "Field_" + i;
        }
        return this.fieldNames;
    }

    public long getLineNumber() {
        return this.lineNumber;
    }

    public void reset() throws DataSourceException {
        try {
            this.in.close();
            if (!this.file.exists()) {
                throw new FileNotFoundException(HuginGUIConstants.get("str_file_") + this.file.getName() + HuginGUIConstants.get("str__not_found"));
            }
            try {
                this.in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), this.encoding));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                new HuginGUIError(unsupportedEncodingException.getMessage() + HuginGUIConstants.get("str_lb_lb_using_default_encoding"));
                this.in = new BufferedReader(new FileReader(this.file));
            }
            if (this.readNames) {
                this.in.readLine();
            }
            this.lineNumber = 1L;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new DataSourceException(fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            throw new DataSourceException(iOException.getMessage());
        }
    }

    public void close() throws DataSourceException {
        try {
            this.in.close();
        }
        catch (Exception exception) {
            throw new DataSourceException(exception.getMessage());
        }
    }

    public void setExcluded(boolean[] blArray) {
    }
}

