/*
 * Decompiled with CFR 0.152.
 */
package COM.hugin.HGUI;

import COM.hugin.HAPI.BooleanDCNode;
import COM.hugin.HAPI.ContinuousChanceNode;
import COM.hugin.HAPI.DiscreteChanceNode;
import COM.hugin.HAPI.Domain;
import COM.hugin.HAPI.ExceptionHugin;
import COM.hugin.HAPI.IntervalDCNode;
import COM.hugin.HAPI.LabelledDCNode;
import COM.hugin.HAPI.Node;
import COM.hugin.HAPI.NumberedDCNode;
import COM.hugin.HGUI.HuginGUIConstants;
import COM.hugin.HGUI.InvalidDataException;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Variable
implements Cloneable {
    private DiscreteChanceNode node;
    private ContinuousChanceNode contNode;
    private String state;
    protected int caseNumber;
    protected boolean excluded;
    private static String[] nullValues = HuginGUIConstants.NULL_VALUES;
    private String nodeName;
    private int mode;
    protected Domain domain;
    private Hashtable<String, Integer> stateMapping;
    public static boolean numberWasValid = true;
    private static char[] infinity = new char[]{'i', 'n', 'f', 'i', 'n', 'i', 't', 'y'};
    private static char[] INFINITY = new char[]{'I', 'N', 'F', 'I', 'N', 'I', 'T', 'Y'};

    public Variable() {
        this.node = null;
        this.contNode = null;
        this.state = "n/a";
        this.excluded = false;
        this.stateMapping = new Hashtable();
    }

    public Variable(String string, Domain domain, int n) throws ExceptionHugin {
        String string2 = string.trim();
        if (string2 == null) {
            this.node = null;
            this.state = null;
            this.excluded = true;
            return;
        }
        this.domain = domain;
        this.mode = n;
        this.excluded = false;
        this.node = null;
        Node node = domain.getNodeByName(this.legalize(string2));
        if (node == null) {
            node = this.getNodeByName(string2);
        }
        if (node instanceof DiscreteChanceNode) {
            this.node = (DiscreteChanceNode)node;
            this.nodeName = string2;
        }
        if (node instanceof ContinuousChanceNode) {
            this.contNode = (ContinuousChanceNode)node;
            this.nodeName = string2;
        }
        if (this.node == null) {
            if (n == 1) {
                this.nodeName = string2;
                return;
            }
            this.node = new LabelledDCNode(domain);
            this.nodeName = this.legalize(string2);
            this.node.setLabel(string2);
            this.node.setName(this.nodeName);
        }
        this.state = "n/a";
        this.stateMapping = this.createMapping(this.node);
    }

    public Variable(IntervalDCNode intervalDCNode) throws ExceptionHugin {
        this.domain = intervalDCNode.getHomeDomain();
        this.excluded = false;
        this.node = intervalDCNode;
        this.nodeName = this.node.getName();
        this.state = "n/a";
        this.stateMapping = this.createMapping(intervalDCNode);
    }

    public void setNode(Node node) throws ExceptionHugin {
        if (node instanceof DiscreteChanceNode) {
            this.node = (DiscreteChanceNode)node;
            this.stateMapping = this.createMapping(this.node);
        } else if (node instanceof ContinuousChanceNode) {
            this.contNode = (ContinuousChanceNode)node;
        }
        this.nodeName = node.getName();
    }

    public void setIntervalNode(IntervalDCNode intervalDCNode) throws ExceptionHugin {
        if (this.excluded) {
            return;
        }
        String string = this.node.getName();
        String string2 = this.node.getLabel();
        this.node.delete();
        this.node = intervalDCNode;
        this.node.setName(string);
        if (string2 != null) {
            this.node.setLabel(string2);
        }
        this.stateMapping = this.createMapping(intervalDCNode);
    }

    public Node getNodeByName(String string) {
        String string2 = string.trim();
        try {
            for (Node node : this.domain.getNodes()) {
                if (!node.getName().toLowerCase().equals(string2.toLowerCase())) continue;
                return node;
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            // empty catch block
        }
        return null;
    }

    public IntervalDCNode getIntervalNode() {
        if (!(this.node instanceof IntervalDCNode)) {
            return null;
        }
        return (IntervalDCNode)this.node;
    }

    public double[] getIntervals() throws ExceptionHugin {
        if (!(this.node instanceof IntervalDCNode)) {
            return null;
        }
        double[] dArray = new double[this.node.getNumberOfStates() + 1];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = ((IntervalDCNode)this.node).getStateValue(i);
        }
        return dArray;
    }

    public void resetNode(Domain domain) throws ExceptionHugin {
        if (this.excluded) {
            return;
        }
        String string = this.node.getName();
        String string2 = this.node.getLabel();
        this.node.delete();
        this.node = new LabelledDCNode(domain);
        this.node.setName(string);
        if (string2 != null) {
            this.node.setLabel(string2);
        }
    }

    protected boolean setState(String string, int n) throws InvalidDataException {
        if (this.excluded) {
            return false;
        }
        this.state = string == null ? "n/a" : string;
        this.caseNumber = n;
        return Variable.isNull(this.state);
    }

    protected boolean insert(String string, int n) throws ExceptionHugin, InvalidDataException {
        if (this.excluded) {
            return false;
        }
        this.setState(string, n);
        return this.insert();
    }

    protected boolean insert() throws ExceptionHugin, InvalidDataException {
        if (this.excluded) {
            return false;
        }
        if (Variable.isNull(this.state)) {
            return true;
        }
        if (this.contNode != null) {
            try {
                this.contNode.setCaseValue(this.caseNumber, Double.parseDouble(this.state));
                return false;
            }
            catch (Exception exception) {
                throw new InvalidDataException(this.state + HuginGUIConstants.get("str__not_continuous_value"));
            }
        }
        if (this.mode == 1 && this.node == null) {
            return false;
        }
        int n = this.getStateNumber();
        if (n >= 0) {
            this.node.setCaseState(this.caseNumber, n);
        }
        return false;
    }

    private Hashtable<String, Integer> createMapping(DiscreteChanceNode discreteChanceNode) throws ExceptionHugin {
        Hashtable<String, Integer> hashtable;
        block5: {
            int n;
            block7: {
                block6: {
                    block4: {
                        hashtable = new Hashtable<String, Integer>();
                        n = discreteChanceNode.getNumberOfStates();
                        if (n == 1 && discreteChanceNode.getStateLabel(0).length() == 0) {
                            return hashtable;
                        }
                        if (!(discreteChanceNode instanceof LabelledDCNode)) break block4;
                        for (int i = 0; i < n; ++i) {
                            hashtable.put(discreteChanceNode.getStateLabel(i).toLowerCase(), new Integer(i));
                        }
                        break block5;
                    }
                    if (!(discreteChanceNode instanceof BooleanDCNode)) break block6;
                    hashtable.put("false", new Integer(0));
                    hashtable.put("true", new Integer(1));
                    break block5;
                }
                if (!(discreteChanceNode instanceof NumberedDCNode)) break block7;
                for (int i = 0; i < n; ++i) {
                    hashtable.put("" + ((NumberedDCNode)discreteChanceNode).getStateValue(i), new Integer(i));
                }
                break block5;
            }
            if (!(discreteChanceNode instanceof IntervalDCNode)) break block5;
            for (int i = 0; i < n; ++i) {
                hashtable.put(((IntervalDCNode)discreteChanceNode).getStateValue(i) + " - " + ((IntervalDCNode)discreteChanceNode).getStateValue(i + 1), new Integer(i));
            }
        }
        return hashtable;
    }

    protected boolean insertOrCreate() throws ExceptionHugin, InvalidDataException {
        if (this.excluded) {
            return false;
        }
        if (Variable.isNull(this.state)) {
            return true;
        }
        if (this.mode == 1 && this.node == null) {
            return false;
        }
        int n = this.getStateNumber();
        if (n < 0 && this.mode == 1) {
            return false;
        }
        if (n >= 0) {
            this.node.setCaseState(this.caseNumber, n);
        } else {
            n = 0;
            if (this.node.getNumberOfStates() == 1 && this.node.getStateLabel(0).equals("")) {
                this.node.setStateLabel(0, this.state);
                this.stateMapping.put(this.state.toLowerCase(), new Integer(0));
            } else {
                n = this.node.getNumberOfStates();
                this.node.setNumberOfStates(n + 1);
                this.node.setStateLabel(n, this.state);
                this.stateMapping.put(this.state.toLowerCase(), new Integer(n));
            }
            this.node.setCaseState(this.caseNumber, n);
        }
        return false;
    }

    protected static boolean isNull(String string) {
        if (string == null) {
            return true;
        }
        String string2 = string.toLowerCase();
        for (int i = 0; i < nullValues.length; ++i) {
            if (!string2.equals(nullValues[i])) continue;
            return true;
        }
        return false;
    }

    private int getStateNumber() throws ExceptionHugin {
        if (this.node instanceof LabelledDCNode || this.node instanceof BooleanDCNode) {
            Integer n = this.stateMapping.get(this.state.toLowerCase());
            return n != null ? n : -1;
        }
        if (this.node instanceof NumberedDCNode) {
            try {
                char[] cArray = this.state.toCharArray();
                double d = Variable.atof(cArray, 0, cArray.length);
                if (!numberWasValid) {
                    return -1;
                }
                for (int i = 0; i < this.node.getNumberOfStates(); ++i) {
                    double d2;
                    double d3 = ((NumberedDCNode)this.node).getStateValue(i);
                    if (!(d >= d3 - (d2 = Math.abs(d3 / 100000.0))) || !(d <= d3 + d2)) continue;
                    return i;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return -1;
        }
        if (this.node instanceof IntervalDCNode) {
            double d = 0.0;
            char[] cArray = this.state.toCharArray();
            int n = Variable.getSeparator(cArray);
            if (n < cArray.length) {
                double d4;
                double d5;
                if (Variable.isInfinity(cArray, 0, n, true)) {
                    d5 = -1.7976931348623157E308;
                } else {
                    d5 = Variable.atof(cArray, 0, n);
                    if (!numberWasValid) {
                        return -1;
                    }
                }
                if (Variable.isInfinity(cArray, n + 1, cArray.length, false)) {
                    d4 = Double.MAX_VALUE;
                } else {
                    d4 = Variable.atof(cArray, n + 1, cArray.length);
                    if (!numberWasValid) {
                        return -1;
                    }
                }
                d = d5 + (d4 - d5) / 2.0;
            } else {
                d = Variable.atof(cArray, 0, cArray.length);
            }
            if (!numberWasValid) {
                return -1;
            }
            for (int i = 0; i < this.node.getNumberOfStates(); ++i) {
                if (!(d >= ((IntervalDCNode)this.node).getStateValue(i)) || !(d < ((IntervalDCNode)this.node).getStateValue(i + 1))) continue;
                return i;
            }
        }
        return -1;
    }

    public void relabel(String string) throws ExceptionHugin {
        this.node.setLabel(string);
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getName() {
        String string = "";
        if (this.excluded && this.node == null) {
            return null;
        }
        try {
            if (this.mode == 1 && this.node == null) {
                return this.nodeName;
            }
            return this.node.getName();
        }
        catch (ExceptionHugin exceptionHugin) {
            return string;
        }
    }

    public String getNameOrLabel() {
        String string = "";
        if (this.excluded && this.node == null) {
            return null;
        }
        try {
            if (this.mode == 1 && this.node == null) {
                return this.nodeName;
            }
            string = this.node.getLabel();
            if (string == null || string.length() == 0) {
                string = this.node.getName();
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            // empty catch block
        }
        return string;
    }

    public String getRealName() {
        String string = "";
        if (this.excluded && this.node == null) {
            return null;
        }
        try {
            if (this.mode == 1 && this.node == null) {
                return this.nodeName;
            }
            if (string == null || string.length() == 0) {
                string = this.node.getName();
            }
        }
        catch (ExceptionHugin exceptionHugin) {
            // empty catch block
        }
        return string;
    }

    public Object clone() {
        Variable variable = new Variable();
        variable.node = this.node;
        variable.contNode = this.contNode;
        variable.state = variable.state == null ? "n/a" : this.state;
        variable.excluded = this.excluded;
        variable.caseNumber = this.caseNumber;
        return variable;
    }

    public String toString() {
        if (this.excluded) {
            return null;
        }
        return this.state;
    }

    public String getState() {
        if (this.excluded) {
            return null;
        }
        return this.state;
    }

    public void exclude() throws ExceptionHugin {
        this.excluded = true;
        if (this.mode == 1) {
            if (this.node == null) {
                return;
            }
            return;
        }
        if (this.node != null) {
            this.node.delete();
            this.node = null;
        }
    }

    public void include(String string) throws ExceptionHugin {
        String string2 = string.trim();
        this.excluded = false;
        if (this.mode == 1) {
            if (this.node == null) {
                return;
            }
            return;
        }
        if (this.node == null) {
            this.node = new LabelledDCNode(this.domain);
            this.nodeName = this.legalize(string2);
            if (!this.nodeName.equals(string2)) {
                this.node.setLabel(string2);
            }
            this.node.setName(this.nodeName);
            this.stateMapping = this.createMapping(this.node);
        }
    }

    public void include(String string, double[] dArray) throws ExceptionHugin {
        String string2 = string.trim();
        this.excluded = false;
        this.node = new IntervalDCNode(this.domain);
        this.nodeName = this.legalize(string2);
        if (!this.nodeName.equals(string2)) {
            this.node.setLabel(string2);
        }
        this.node.setName(this.nodeName);
        ((IntervalDCNode)this.node).setNumberOfStates(dArray.length - 1);
        for (int i = 0; i < dArray.length; ++i) {
            ((IntervalDCNode)this.node).setStateValue(i, dArray[i]);
        }
    }

    public boolean isExcluded() {
        return this.excluded;
    }

    public void delete() {
        try {
            if (this.node != null) {
                this.node.delete();
            }
            this.node = null;
            if (this.contNode != null) {
                this.contNode.delete();
            }
            this.contNode = null;
        }
        catch (ExceptionHugin exceptionHugin) {
            // empty catch block
        }
    }

    protected String legalize(String string) throws ExceptionHugin {
        int n;
        String string2 = string.trim();
        if (string2 == null || string2.length() == 0) {
            String string3 = "Field_1";
            int n2 = 2;
            while (this.nameExists(string3)) {
                string3 = "Field_" + n2;
                ++n2;
            }
            return string3;
        }
        int n3 = string2.lastIndexOf(46);
        if (!this.legalChar(string2.charAt(0), true)) {
            string2 = "Field_" + string2;
        }
        char[] cArray = string2.toCharArray();
        for (n = 1; n < string2.length(); ++n) {
            if (this.legalChar(cArray[n], n == 0)) continue;
            cArray[n] = 95;
        }
        String string4 = new String(cArray);
        n = 1;
        while (this.nameExists(string4)) {
            string4 = new String(cArray) + "_" + n;
            ++n;
        }
        return string4;
    }

    protected boolean legalChar(char c, boolean bl) {
        if (bl) {
            return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
        }
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_';
    }

    protected boolean nameExists(String string) throws ExceptionHugin {
        String string2 = string.trim();
        if (this.node == null) {
            return false;
        }
        Node node = this.node.getHome().getNodeByName(string2);
        return node != null;
    }

    public boolean containsNode() {
        return this.node != null || this.contNode != null;
    }

    public Node getNode() {
        return this.node;
    }

    public static double atof(String string) {
        return Variable.atof(string.toCharArray(), 0, string.length());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double atof(char[] cArray, int n, int n2) {
        int n3;
        numberWasValid = true;
        int n4 = 1;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 1.0;
        boolean bl = false;
        for (n3 = n; n3 < n2 && Character.isWhitespace(cArray[n3]); ++n3) {
        }
        if (n3 < n2 && cArray[n3] == '-') {
            n4 = -1;
            ++n3;
        } else if (n3 < n2 && cArray[n3] == '+') {
            ++n3;
        }
        while (n3 < n2) {
            char c = cArray[n3];
            if ('0' <= c && c <= '9') {
                if (!bl) {
                    d = d * 10.0 + (double)c - 48.0;
                } else if (bl) {
                    d += (d3 /= 10.0) * (double)(c - 48);
                }
            } else if (c == '.') {
                if (bl) return (double)n4 * d;
                bl = true;
            } else {
                if (c == 'e' || c == 'E') {
                    long l = (int)Variable.parseLong(cArray, n3 + 1, n2, 10);
                    return (double)n4 * d * Math.pow(10.0, l);
                }
                while (n3 < n2 && Character.isWhitespace(cArray[n3])) {
                    ++n3;
                }
                numberWasValid = n3 == n2;
                return (double)n4 * d;
            }
            ++n3;
        }
        return (double)n4 * d;
    }

    private static long parseLong(char[] cArray, int n, int n2, int n3) {
        int n4;
        numberWasValid = true;
        int n5 = 1;
        long l = 0L;
        for (n4 = n; n4 < n2 && Character.isWhitespace(cArray[n4]); ++n4) {
        }
        if (n4 < n2 && cArray[n4] == '-') {
            n5 = -1;
            ++n4;
        } else if (n4 < n2 && cArray[n4] == '+') {
            ++n4;
        }
        while (n4 < n2) {
            char c = cArray[n4];
            if ('0' <= c && c < 48 + n3) {
                l = l * (long)n3 + (long)c - 48L;
            } else if ('A' <= c && c < 65 + n3 - 10) {
                l = l * (long)n3 + (long)c - 65L + 10L;
            } else if ('a' <= c && c < 97 + n3 - 10) {
                l = l * (long)n3 + (long)c - 97L + 10L;
            } else {
                while (n4 < n2 && Character.isWhitespace(cArray[n4])) {
                    ++n4;
                }
                numberWasValid = n4 == n2;
                return l * (long)n5;
            }
            ++n4;
        }
        return l * (long)n5;
    }

    public static int getSeparator(char[] cArray) {
        int n;
        int n2 = cArray.length;
        boolean bl = false;
        for (n = 0; n < n2 && Character.isWhitespace(cArray[n]); ++n) {
        }
        if (n < n2 && cArray[n] == '-') {
            ++n;
        }
        while (n < n2) {
            char c = cArray[n];
            if (c == '-') {
                return n;
            }
            if (c == 'e' || c == 'E') {
                ++n;
            }
            ++n;
        }
        return n2;
    }

    private static boolean isInfinity(char[] cArray, int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5 = cArray.length;
        for (n4 = n; n4 < n2 && Character.isWhitespace(cArray[n4]); ++n4) {
        }
        if (n4 == n2 || bl && cArray[n4] != '-') {
            return false;
        }
        if (bl || cArray[n4] == '+') {
            ++n4;
        }
        if (n4 + 3 > n2) {
            return false;
        }
        for (n3 = 0; n3 < 3; ++n3) {
            if (cArray[n4 + n3] == infinity[n3] || cArray[n4 + n3] == INFINITY[n3]) continue;
            return false;
        }
        ++n3;
        if ((n4 += 4) >= n2) {
            return true;
        }
        if (cArray[n4] != infinity[n3] && cArray[n4] != INFINITY[n3]) {
            while (n4 < n2 && Character.isWhitespace(cArray[n4])) {
                ++n4;
            }
            return n4 == n2;
        }
        boolean bl2 = false;
        while (n4 < n2) {
            if (!bl2) {
                if (cArray[n4] != infinity[n3] && cArray[n4] != INFINITY[n3]) {
                    return false;
                }
                bl2 = n3 + 1 == infinity.length;
            } else if (!Character.isWhitespace(cArray[n4])) {
                return false;
            }
            ++n4;
            ++n3;
        }
        return true;
    }
}

