<?xml version="1.0"?>

<!-- File Name: Gpevents.xsl -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/TR/WD-xsl">
	<xsl:template match="/">
		<H2>Group Policy Events</H2>
		<TABLE BORDER="1" CELLPADDING="5">
			<THEAD>
				<TH>Date and time</TH>
				<TH>Level</TH>
				<TH>Event ID</TH>
				<TH>Description</TH>
				<TH>Error Code</TH>
			</THEAD>
			<xsl:for-each select="GroupPolicyEvents/GPEvent" order-by="+Event/System/TimeCreated/@SystemTime">
				<TR ALIGN="CENTER">
					<TD>
						<xsl:value-of select="Event/System/TimeCreated/@SystemTime"/>
					</TD>
					<TD>
						<xsl:value-of select="Event/System/Level"/>
					</TD>
					<TD>
						<xsl:value-of select="Event/System/EventID"/>
					</TD>
					<TD>
						<xsl:value-of select="Description"/>
					</TD>
					<TD>
						<xsl:value-of select="Event/EventData/Data[@Name='ErrorCode']"/>
					</TD>
				</TR>
			</xsl:for-each>
		</TABLE>
	</xsl:template>
</xsl:stylesheet>
	
