/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 *
 * @author Vojta
 */
import java.io.*;
import java.util.*;
import be.ac.ulg.montefiore.run.jahmm.ObservationDiscrete;


/**
 *
 * @author VojtaB
 */
public class ReadFasta {
    private int symbol = -1;
    private BufferedReader reader;
    private HashMap alphabet;
    private File file;
    private LinkedList<String> headers;
    private String header;
    private List<List<ObservationDiscrete>> observations;
    private Map<String,ArrayList<ObservationDiscrete>> observationswithhead;
    private int last;
    public int readerstatus;


    public ReadFasta(File file) throws FileNotFoundException  {
        headers = new LinkedList();
        this.file = file;
        reader = new BufferedReader(new FileReader(file));
        alphabet = new HashMap(30);
        alphabet.put(new Integer(67),new Integer(1));       // C
        alphabet.put(new Integer(83),new Integer(2));       // S
        alphabet.put(new Integer(84),new Integer(3));       // T
        alphabet.put(new Integer(80),new Integer(4));       // P
        alphabet.put(new Integer(65),new Integer(5));       // A
        alphabet.put(new Integer(71),new Integer(6));       // G
        alphabet.put(new Integer(78),new Integer(7));       // N
        alphabet.put(new Integer(68),new Integer(8));       // D
        alphabet.put(new Integer(69),new Integer(9));       // E
        alphabet.put(new Integer(81),new Integer(10));      // Q
        alphabet.put(new Integer(72),new Integer(11));      // H
        alphabet.put(new Integer(82),new Integer(12));      // R
        alphabet.put(new Integer(75),new Integer(13));      // K
        alphabet.put(new Integer(77),new Integer(14));      // M
        alphabet.put(new Integer(73),new Integer(15));      // I
        alphabet.put(new Integer(76),new Integer(16));      // L
        alphabet.put(new Integer(86),new Integer(17));      // V
        alphabet.put(new Integer(70),new Integer(18));      // F
        alphabet.put(new Integer(89),new Integer(19));      // Y
        alphabet.put(new Integer(87),new Integer(20));      // W
        alphabet.put(new Integer(88),new Integer(21));       // X   ignored
        alphabet.put(new Integer(90),new Integer(21));       // Z   ignored
        alphabet.put(new Integer(66),new Integer(21));       // B   ignored
        alphabet.put(new Integer(85),new Integer(21));       // U   ignored
        alphabet.put(new Integer(79),new Integer(21));       // O   ignored
        alphabet.put(new Integer(13),new Integer(0));       //     ignored
        alphabet.put(new Integer(10),new Integer(0));       // new line  ignored
        alphabet.put(new Integer(32),new Integer(0));       // space     ignored
        alphabet.put(new Integer(62),new Integer(30));      // >         new sequence
    }

    public ReadFasta(String filepath) throws FileNotFoundException  {
        headers = new LinkedList();
        this.file = new File(filepath);
        reader = new BufferedReader(new FileReader(file));
        alphabet = new HashMap(30);
        alphabet.put(new Integer(67),new Integer(1));       // C
        alphabet.put(new Integer(83),new Integer(2));       // S
        alphabet.put(new Integer(84),new Integer(3));       // T
        alphabet.put(new Integer(80),new Integer(4));       // P
        alphabet.put(new Integer(65),new Integer(5));       // A
        alphabet.put(new Integer(71),new Integer(6));       // G
        alphabet.put(new Integer(78),new Integer(7));       // N
        alphabet.put(new Integer(68),new Integer(8));       // D
        alphabet.put(new Integer(69),new Integer(9));       // E
        alphabet.put(new Integer(81),new Integer(10));      // Q
        alphabet.put(new Integer(72),new Integer(11));      // H
        alphabet.put(new Integer(82),new Integer(12));      // R
        alphabet.put(new Integer(75),new Integer(13));      // K
        alphabet.put(new Integer(77),new Integer(14));      // M
        alphabet.put(new Integer(73),new Integer(15));      // I
        alphabet.put(new Integer(76),new Integer(16));      // L
        alphabet.put(new Integer(86),new Integer(17));      // V
        alphabet.put(new Integer(70),new Integer(18));      // F
        alphabet.put(new Integer(89),new Integer(19));      // Y
        alphabet.put(new Integer(87),new Integer(20));      // W
        alphabet.put(new Integer(88),new Integer(21));       // X   ignored
        alphabet.put(new Integer(90),new Integer(21));       // Z   ignored
        alphabet.put(new Integer(66),new Integer(21));       // B   ignored
        alphabet.put(new Integer(85),new Integer(21));       // U   ignored
        alphabet.put(new Integer(79),new Integer(21));       // O   ignored
        alphabet.put(new Integer(13),new Integer(0));       //     ignored
        alphabet.put(new Integer(10),new Integer(0));       // new line  ignored
        alphabet.put(new Integer(32),new Integer(0));       // space     ignored
        alphabet.put(new Integer(62),new Integer(30));      // >         new sequence
    }

    private AAcid intToE(int s){
        switch(s){
            case 67:return AAcid.C;
            case 83:return AAcid.S;
            case 84:return AAcid.T;
            case 80:return AAcid.P;
            case 65:return AAcid.A;
            case 71:return AAcid.G;
            case 78:return AAcid.N;
            case 68:return AAcid.D;
            case 69:return AAcid.E;
            case 81:return AAcid.Q;
            case 72:return AAcid.H;
            case 82:return AAcid.R;
            case 75:return AAcid.K;
            case 77:return AAcid.M;
            case 73:return AAcid.I;
            case 76:return AAcid.L;
            case 86:return AAcid.V;
            case 70:return AAcid.F;
            case 89:return AAcid.Y;
            case 87:return AAcid.W;
            case 88:return AAcid.X;
            case 90:return AAcid.X;
            case 66:return AAcid.X;
            case 85:return AAcid.X;
            case 79:return AAcid.X;
        }
        return null;
    }

    public int makeStep() throws IOException {
        symbol = reader.read();
        if(intToE(symbol) != null){
            observations.get(last).add(new ObservationDiscrete(intToE(symbol)));
        } else {
            if(symbol == 62) return 1;
            if(symbol == -1) return 3;
        }
        return 2;
    }

    public int makeStepHeader() throws IOException {
        symbol = reader.read();
        if(intToE(symbol) != null){
            observationswithhead.get(header).add(new ObservationDiscrete(intToE(symbol)));
        } else {
            if(symbol == 62) return 1;
            if(symbol == -1) return 3;
        }
        return 2;
    }

    public int readHeader() throws IOException{
        header = reader.readLine();
        return 2;
    }

    public int startFile() throws IOException{
        int state = 0;
        while(state == 0){
            switch(reader.read()){
                case -1: state = 3;
                break;
                case 62: state = 1;
                break;
            }
        }
        return state;
    }

    public List<ObservationDiscrete> readFileFlat(int length) throws IOException{
        int pos = 0;
        readerstatus = 1;
        observations = new LinkedList<List<ObservationDiscrete>>();
        observations.add(new LinkedList<ObservationDiscrete>());
        readerstatus = readerstatus * startFile();
        while(readerstatus == 2 || readerstatus == 1){
           readerstatus = makeStep();
           pos++;
           if(pos > length) readerstatus = 3;
        }
      //  throw WrongFileFormatException
        return observations.get(0);
    }

    public List<List<ObservationDiscrete>> readFile(int max) throws IOException{
        readerstatus = 1;
        last = 0;
        observations = new LinkedList<List<ObservationDiscrete>>();
        readerstatus = readerstatus * startFile();
        while(readerstatus == 1){
            System.gc();
            readerstatus = readHeader();
            observations.add(new LinkedList<ObservationDiscrete>());
            while(readerstatus == 2){
               readerstatus = makeStep();
            }
            if(observations.get(last).isEmpty()) observations.remove(last);
            else last++;
            if(last > max) readerstatus = 3;
        }
      //  throw WrongFileFormatException
        return observations;
    }



    public Map<String,ArrayList<ObservationDiscrete>> readFileWithHeader(int max) throws IOException{
        readerstatus = 1;
        last = 0;
        observationswithhead = new HashMap<String,ArrayList<ObservationDiscrete>>();
        readerstatus = readerstatus * startFile();
        while(readerstatus == 1){
            System.gc();
            readerstatus = readHeader();
            observationswithhead.put(header,new ArrayList<ObservationDiscrete>());
            while(readerstatus == 2){
               readerstatus = makeStepHeader();
            }

            if(observationswithhead.get(header).isEmpty()) observationswithhead.remove(header);
            else last++;
            if(last > max) readerstatus = 3;
        }
      //  throw WrongFileFormatException
        return observationswithhead;
    }

    public Map<String,ArrayList<ObservationDiscrete>> readFileWithHeader() throws IOException{
        readerstatus = 1;
        last = 0;
        observationswithhead = new HashMap<String,ArrayList<ObservationDiscrete>>();
        readerstatus = readerstatus * startFile();
        while(readerstatus == 1){
            System.gc();
            readerstatus = readHeader();
            observationswithhead.put(header,new ArrayList<ObservationDiscrete>());
            while(readerstatus == 2){
               readerstatus = makeStepHeader();
            }
             System.out.print(last + ", ");
            if(observationswithhead.get(header).isEmpty()) observationswithhead.remove(header);
            else last++;
        }
      //  throw WrongFileFormatException
        return observationswithhead;
    }

    public List<List<ObservationDiscrete>> readFile(int[] indexes) throws IOException{
        readerstatus = 1;
        int index = 0;
        last = 0;
        observations = new LinkedList<List<ObservationDiscrete>>();
        readerstatus = readerstatus * startFile();
        while(readerstatus == 1){
            System.gc();
            readerstatus = readHeader();
            observations.add(new LinkedList<ObservationDiscrete>());
            while(readerstatus == 2){
               readerstatus = makeStep();
            }
            if(observations.get(last).isEmpty()) observations.remove(last);
            else last++;
            if(last > index) readerstatus = 3;
        }
      //  throw WrongFileFormatException
        return observations;
    }

    public List<List<ObservationDiscrete>> readFile() throws IOException{
        readerstatus = 1;
        last = 0;
        observations = new LinkedList<List<ObservationDiscrete>>();
        readerstatus = readerstatus * startFile();
        while(readerstatus == 1){
            System.gc();
            readerstatus = readHeader();
            observations.add(new LinkedList<ObservationDiscrete>());
            while(readerstatus == 2){
               readerstatus = makeStep();
            }
            if(observations.get(last).isEmpty()) observations.remove(last);
            else last++;
        }
      //  throw WrongFileFormatException
        return observations;
    }

    public int getLength(){
        return (int) file.length();
    }

    public String getHeader(int i){
        return headers.get(i);
    }

    public void close() throws IOException{
        reader.close();
    }

}

