/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.muni.fi.bar.schemaxslt;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/**
 *
 * @author bar
 */
public class SchemaValidator {
    
    public static void main(String[] args) {
        try {
            SchemaFactory sf = SchemaFactory.newDefaultInstance();
            Schema schema = sf.newSchema(new File("src/schema.xsd"));
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newDefaultInstance();
            dbf.setNamespaceAware(true);
            dbf.setSchema(schema);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(new ValidationErrorHandler());
            System.err.print("Validating data.xml: ");
            Document doc = db.parse("src/data.xml");
            System.out.println("OK");
        } catch (ParserConfigurationException | SAXException | IOException ex) {
            Logger.getLogger(SchemaValidator.class.getName()).log(Level.SEVERE, null, ex);
            System.err.println("FAILED");
        }
        
    }

    private static class ValidationErrorHandler implements ErrorHandler {

        
        @Override
        public void warning(SAXParseException exception) throws SAXException {
            Logger.getAnonymousLogger().log(Level.INFO, exception.getMessage());
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            throw new SAXException(exception.getMessage(), exception);
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            throw new SAXException(exception.getMessage(),exception);
        }
    }
    
}
