#include "clock.h"

#include <chrono>
#include <thread>

// What is the point of this file and API?
//
// Well, this is necessary on embedded  devices, where you have to manually
// prepare/setup your clock for the system. Originally (for the embedded version
// of the project) this implemented with these functions.
//
//  - clock_init() was required to setup the hardware peripheral of the
//  embedded device for counting the time. (Simple timer)
//  - clock_time() returns time based on how the timer counted it
//  - clock_delay_ms() is just handy function for sleeping that used the
//  facillity provided by the timer
//
// In case of desktop version it is not necessary, but we prefer to use it as it
// has certain benefits for testing from our side, we also figured that it is
// little bit easier to get proper clock in C++ than C in multiplatform way.

std::chrono::system_clock::time_point start;

extern "C" {

void clock_init() { start = std::chrono::system_clock::now(); }

uint32_t clock_time() {
    auto t_now = std::chrono::system_clock::now();
    return std::chrono::duration_cast<std::chrono::milliseconds>(t_now - start)
        .count();
}

void clock_delay_ms(uint32_t n) {
    std::chrono::milliseconds t{n};
    std::this_thread::sleep_for(t);
}
}
