#include "task.h"

#ifndef SCHEDULER_H_
#define SCHEDULER_H_

// struct containing data for the scheduler
struct scheduler {
    // Implement yourself
};

// only instance of scheduler, you should use this, as it is used by periodic
// jobs in sporadic set to insert sporadic event.
extern struct scheduler SCHEDULER;

// This is the main scheduling function, you receive a pointer to array of
// pointers to tasks structures. Count of tasks in the array. A bool variable
// `has_sporadic` that is 1 in case the scheduler should expect a sporadic job
// and 0 when it should not expect sporadic job.
//
// Remember to use the `SCHEDULER` global variable and
void schedule(struct task** tasks, int count, int has_sporadic);

// Function that notifies scheduler of new sporadic event that should be
// scheduled by it. It returns 1 in case of success and 0 in case the event was
// declined.
int scheduler_on_sporadic(struct scheduler* sched, struct sporadic_event e);

// globals are bad ....
//
// Global variables are something that should be used visely and in this
// scenario, the simplicity of using global variable here outweights the
// complexity consequences of avoiding it and having abillity to reasonably
// insert new sporadic jobs into the scheduler. That is purely done because this
// course is not supposed to be about C, but about schedulers.
//
// To put it diffrently: In case this would be production code, we would force
// you to implement it without a need of global variable.

#endif

