#include "sporadic_tasks.h"

#include <stdlib.h>

#include "clock.h"
#include "scheduler.h"

void sporadic_fun(void* raw_ptr) {
  printf("%i: something random happend\n", clock_time());
}

// Sporadic Task 1
// ----------------------------------------------------------------------------
// May create a sporadic job

void spor_job_1(void* raw_ptr) {
  if (rand() % 42 == 0) {
    struct sporadic_event e = {.relative_deadline = 21,
			       .max_execution_time = 3,
			       .job = &sporadic_fun,
			       .data = NULL};
    scheduler_on_sporadic(&SCHEDULER, e);
  }
}

struct task SPOR_TASK_1 = {.period = 16,
			   .max_execution_time = 11,
			   .relative_deadline = 16,
			   .job = &spor_job_1,
			   .data = NULL};

// Sporadic Task 2
// ----------------------------------------------------------------------------
// May create a sporadic job

void spor_job_2(void* raw_ptr) {
  if (rand() % 42 == 0) {
    struct sporadic_event e = {.relative_deadline = 21,
			       .max_execution_time = 3,
			       .job = &sporadic_fun,
			       .data = NULL};
    scheduler_on_sporadic(&SCHEDULER, e);
  }
}

struct task SPOR_TASK_2 = {.period = 74,
			   .max_execution_time = 5,
			   .relative_deadline = 32,
			   .job = &spor_job_2,
			   .data = NULL};
