# generate data files for exercise within Experiments seminar dedicated to quantitative evaluation of experiments

# each datafile contains 12001 rows, the first one with description
# for each group (and effect size in treatment groups),
#    we have five files (to be able to reproduce sturdy with different data)
dataSize <- 12000
numberOfFiles <- 5

# generate three files for control group, mean = 100, sd = 15
controlMean <- 100
controlSD <- 15
controlFileName <- "control"

setwd("/home/janka/research/teaching/evaluation_of_experiments/exercise/data/control")
for (i in 1:numberOfFiles) {
  control <- ceiling(rnorm(dataSize, controlMean, controlSD))
  df <- as.data.frame(control)
  controlFileNameComplete <- paste0(controlFileName, "_", i, ".csv")
  write.csv(df, file = controlFileNameComplete, row.names = FALSE)
}

# generate three files for each of the effect sizes in treatment group
effectSizesTreatmentLow <- c(0,0,0,0.6,-0.6,1,3,3, 0, 0, -0.6, 0.6, -1, -3, -3)
treatmentFileName <- "treatment"

setwd("/home/janka/research/teaching/evaluation_of_experiments/exercise/data/treatment")
for(j in 1:length(effectSizesTreatmentLow)) {
  for (i in 1:numberOfFiles) {
    treatment <- ceiling(rnorm(dataSize, controlMean+effectSizesTreatmentLow[j], controlSD))
    df <- as.data.frame(treatment)
    treatmentFileNameComplete <- paste0(treatmentFileName, "-", j, "_", i, ".csv")
    write.csv(df, file = treatmentFileNameComplete, row.names = FALSE)
  }
}

setwd("/home/janka/research/teaching/evaluation_of_experiments/exercise/data/treatment-high")
# generate three files for each of the effect sizes in high treatment group
effectSizesTreatmentHigh <- c(0, 0.6, 2.1, 2.1, 0.6, 3, 3, 5, -0.6, -2.1, -2.1, -0.6, -3, -3, -5)
treatmentHighFileName <- "treatment-high"

for(j in 1:length(effectSizesTreatmentHigh)) {
  for (i in 1:numberOfFiles) {
    treatment <- ceiling(rnorm(dataSize, controlMean+effectSizesTreatmentHigh[j], controlSD))
    df <- as.data.frame(treatment)
    treatmentFileNameComplete <- paste0(treatmentHighFileName, "-", j, "_", i, ".csv")
    write.csv(df, file = treatmentFileNameComplete, row.names = FALSE)
  }
}

setwd("/home/janka/research/teaching/evaluation_of_experiments/exercise/data/exploratory")
dataSize <- 100

control <- ceiling(rnorm(dataSize, controlMean, controlSD))
df <- as.data.frame(control)
controlFileNameComplete <- paste0(controlFileName, "_exploratory.csv")
write.csv(df, file = controlFileNameComplete, row.names = FALSE)
for(j in 1:length(effectSizesTreatmentLow)) {
    treatment <- ceiling(rnorm(dataSize, controlMean+effectSizesTreatmentLow[j], controlSD))
    df <- as.data.frame(treatment)
    treatmentFileNameComplete <- paste0(treatmentFileName, "-", j, "_exploratory.csv")
    write.csv(df, file = treatmentFileNameComplete, row.names = FALSE)
}
for(j in 1:length(effectSizesTreatmentHigh)) {
    treatment <- ceiling(rnorm(dataSize, controlMean+effectSizesTreatmentHigh[j], controlSD))
    df <- as.data.frame(treatment)
    treatmentFileNameComplete <- paste0(treatmentHighFileName, "-", j, "_exploratory.csv")
    write.csv(df, file = treatmentFileNameComplete, row.names = FALSE)
}
