private static byte[] sign(InputStream is, PrivateKey prvKey, String sigAlg) throws Exception {
	// Obtain Signature engine class
	java.security.Signature sig = java.security.Signature.getInstance(sigAlg);
	// Initialize signature with private key
	sig.initSign(prvKey);

	byte[] dataBytes = new byte[2048];
	int nread = is.read(dataBytes);
	while (nread > 0) {
	
		// feeding signature object a new data block to sign
		sig.update(dataBytes, 0, nread);
		nread = is.read(dataBytes);
	}

	// signing itself
	return sig.sign();
}

