/**
 * Turns an array of bytes into a String representing each byte as an
 * unsigned hex number.
 * 
 * @param bytes an array of bytes to convert to a hex-string
 * @return generated hex string
 */
public static String encodeHex(byte[] bytes) {
	StringBuilder buf = new StringBuilder(bytes.length * 2);
	int i;

	for (i = 0; i < bytes.length; i++) {
		if (((int)bytes[i] & 0xff) < 0x10) {
			buf.append("0");
		}
		buf.append(Long.toString((int)bytes[i] & 0xff, 16));
	}
	return buf.toString();
}
