set more off
set matsize 5000
set memory 4G
set scrollbufsize 2048000
use "pisa_2000_2009.dta", clear

gen rok = 2000

replace rok = 2009 if rok == .
 
recode ss4 (3 4 = 3), gen(ss3)

recode ss4 (1=1) (2 3 4 = 2), gen(ss2) 


*DESCRIPTIVE STATISTICS 

*table 2
sum ss4 rok sex older_siblings edu_m3 isei_father pv*read [aw=w_fstuwt] if ss4 != . & ssvzdelani == 1, sep(0) 

*******************************************************

*1). ANALYSIS (plausible values considered)
mlogit ss4  ///
i.rok##i.sex i.rok##i.older_siblings ///
i.rok##i.edu_m3 i.rok##c.isei_father i.rok##c.pv1read ///
[iw=w_fstuwt] if ss4 != . & ssvzdelani == 1, b(1) 

margins rok, at(c.isei_father=(16(1)90)) predict(outcome(1))   
marginsplot 
graph rename vyISEI1, replace

margins rok, at(c.isei_father=(16(1)90)) predict(outcome(2))  
marginsplot 
graph rename ssISEI1, replace

margins rok, at(c.isei_father=(16(1)90)) predict(outcome(3)) 
marginsplot 
graph rename gyISEI1, replace

margins rok, at(c.isei_father=(16(1)90)) predict(outcome(4))  
marginsplot 
graph rename egISEI1, replace

*2). ANALYSIS (plausible values considered)
mlogit ss4  ///
i.rok##i.sex i.rok##i.older_siblings ///
i.rok##i.edu_m3 i.rok##c.isei_father i.rok##c.pv2read ///
[iw=w_fstuwt] if ss4 != . & ssvzdelani == 1, b(1) 

margins rok, at(c.isei_father=(16(1)90)) predict(outcome(1))   
marginsplot 
graph rename vyISEI2, replace

margins rok, at(c.isei_father=(16(1)90)) predict(outcome(2))  
marginsplot 
graph rename ssISEI2, replace

margins rok, at(c.isei_father=(16(1)90)) predict(outcome(3)) 
marginsplot 
graph rename gyISEI2, replace

margins rok, at(c.isei_father=(16(1)90)) predict(outcome(4))  
marginsplot 
graph rename egISEI2, replace

*3). ANALYSIS (plausible values considered)
mlogit ss4  ///
i.rok##i.sex i.rok##i.older_siblings ///
i.rok##i.edu_m3 i.rok##c.isei_father i.rok##c.pv3read ///
[iw=w_fstuwt] if ss4 != . & ssvzdelani == 1, b(1) 

margins rok, at(c.isei_father=(16(1)90)) predict(outcome(1))   
marginsplot 
graph rename vyISEI3, replace

margins rok, at(c.isei_father=(16(1)90)) predict(outcome(2))  
marginsplot 
graph rename ssISEI3, replace

margins rok, at(c.isei_father=(16(1)90)) predict(outcome(3)) 
marginsplot 
graph rename gyISEI3, replace

margins rok, at(c.isei_father=(16(1)90)) predict(outcome(4))  
marginsplot 
graph rename egISEI3, replace

*4). ANALYSIS (plausible values considered)
mlogit ss4  ///
i.rok##i.sex i.rok##i.older_siblings ///
i.rok##i.edu_m3 i.rok##c.isei_father i.rok##c.pv4read ///
[iw=w_fstuwt] if ss4 != . & ssvzdelani == 1, b(1) 

margins rok, at(c.isei_father=(16(1)90)) predict(outcome(1))   
marginsplot 
graph rename vyISEI4, replace

margins rok, at(c.isei_father=(16(1)90)) predict(outcome(2))  
marginsplot 
graph rename ssISEI4, replace

margins rok, at(c.isei_father=(16(1)90)) predict(outcome(3)) 
marginsplot 
graph rename gyISEI4, replace

margins rok, at(c.isei_father=(16(1)90)) predict(outcome(4))  
marginsplot 
graph rename egISEI4, replace

*5). ANALYSIS (plausible values considered)
mlogit ss4  ///
i.rok##i.sex i.rok##i.older_siblings ///
i.rok##i.edu_m3 i.rok##c.isei_father i.rok##c.pv5read ///
[iw=w_fstuwt] if ss4 != . & ssvzdelani == 1, b(1) 

margins rok, at(c.isei_father=(16(1)90)) predict(outcome(1))   
marginsplot 
graph rename vyISEI5, replace

margins rok, at(c.isei_father=(16(1)90)) predict(outcome(2))  
marginsplot 
graph rename ssISEI5, replace

margins rok, at(c.isei_father=(16(1)90)) predict(outcome(3)) 
marginsplot 
graph rename gyISEI5, replace

margins rok, at(c.isei_father=(16(1)90)) predict(outcome(4))  
marginsplot 
graph rename egISEI5, replace


******************************************
*PREDIKCE: theoretical focal persons (educational and economic favorized and defavorized pupils)
quietly mlogit ss4  ///
i.rok##i.sex i.rok##i.older_siblings ///
i.rok##i.edu_m3 i.rok##c.isei_father i.rok##c.pv1read ///
[iw=w_fstuwt] if ss4 != . & ssvzdelani == 1, b(1) 

quietly sum isei_father 
global a=`r(mean)'-`r(sd)'
display $a
margins rok, at(c.isei_father=$a edu_m3=1) predict(outcome(1))    
margins rok, at(c.isei_father=$a edu_m3=1) predict(outcome(2))   
margins rok, at(c.isei_father=$a edu_m3=1) predict(outcome(3))   
margins rok, at(c.isei_father=$a edu_m3=1) predict(outcome(4))   

quietly sum isei_father 
global b=`r(mean)'+`r(sd)'
display $b
margins rok, at(c.isei_father=$b edu_m3=3) predict(outcome(1))   
margins rok, at(c.isei_father=$b edu_m3=3) predict(outcome(2))   
margins rok, at(c.isei_father=$b edu_m3=3) predict(outcome(3))   
margins rok, at(c.isei_father=$b edu_m3=3) predict(outcome(4))   


quietly mlogit ss4  ///
i.rok##i.sex i.rok##i.older_siblings ///
i.rok##i.edu_m3 i.rok##c.isei_father i.rok##c.pv2read ///
[iw=w_fstuwt] if ss4 != . & ssvzdelani == 1, b(1) 

quietly sum isei_father 
global a=`r(mean)'-`r(sd)'
display $a
margins rok, at(c.isei_father=$a edu_m3=1) predict(outcome(1))    
margins rok, at(c.isei_father=$a edu_m3=1) predict(outcome(2))   
margins rok, at(c.isei_father=$a edu_m3=1) predict(outcome(3))   
margins rok, at(c.isei_father=$a edu_m3=1) predict(outcome(4))   

quietly sum isei_father 
global b=`r(mean)'+`r(sd)'
display $b
margins rok, at(c.isei_father=$b edu_m3=3) predict(outcome(1))   
margins rok, at(c.isei_father=$b edu_m3=3) predict(outcome(2))   
margins rok, at(c.isei_father=$b edu_m3=3) predict(outcome(3))   
margins rok, at(c.isei_father=$b edu_m3=3) predict(outcome(4))   


quietly mlogit ss4  ///
i.rok##i.sex i.rok##i.older_siblings ///
i.rok##i.edu_m3 i.rok##c.isei_father i.rok##c.pv3read ///
[iw=w_fstuwt] if ss4 != . & ssvzdelani == 1, b(1) 

quietly sum isei_father 
global a=`r(mean)'-`r(sd)'
display $a
margins rok, at(c.isei_father=$a edu_m3=1) predict(outcome(1))    
margins rok, at(c.isei_father=$a edu_m3=1) predict(outcome(2))   
margins rok, at(c.isei_father=$a edu_m3=1) predict(outcome(3))   
margins rok, at(c.isei_father=$a edu_m3=1) predict(outcome(4))   

quietly sum isei_father 
global b=`r(mean)'+`r(sd)'
display $b
margins rok, at(c.isei_father=$b edu_m3=3) predict(outcome(1))   
margins rok, at(c.isei_father=$b edu_m3=3) predict(outcome(2))   
margins rok, at(c.isei_father=$b edu_m3=3) predict(outcome(3))   
margins rok, at(c.isei_father=$b edu_m3=3) predict(outcome(4))   


quietly mlogit ss4  ///
i.rok##i.sex i.rok##i.older_siblings ///
i.rok##i.edu_m3 i.rok##c.isei_father i.rok##c.pv4read ///
[iw=w_fstuwt] if ss4 != . & ssvzdelani == 1, b(1) 

quietly sum isei_father 
global a=`r(mean)'-`r(sd)'
display $a
margins rok, at(c.isei_father=$a edu_m3=1) predict(outcome(1))    
margins rok, at(c.isei_father=$a edu_m3=1) predict(outcome(2))   
margins rok, at(c.isei_father=$a edu_m3=1) predict(outcome(3))   
margins rok, at(c.isei_father=$a edu_m3=1) predict(outcome(4))   

quietly sum isei_father 
global b=`r(mean)'+`r(sd)'
display $b
margins rok, at(c.isei_father=$b edu_m3=3) predict(outcome(1))   
margins rok, at(c.isei_father=$b edu_m3=3) predict(outcome(2))   
margins rok, at(c.isei_father=$b edu_m3=3) predict(outcome(3))   
margins rok, at(c.isei_father=$b edu_m3=3) predict(outcome(4))   


quietly mlogit ss4  ///
i.rok##i.sex i.rok##i.older_siblings ///
i.rok##i.edu_m3 i.rok##c.isei_father i.rok##c.pv5read ///
[iw=w_fstuwt] if ss4 != . & ssvzdelani == 1, b(1) 

quietly sum isei_father 
global a=`r(mean)'-`r(sd)'
display $a
margins rok, at(c.isei_father=$a edu_m3=1) predict(outcome(1))    
margins rok, at(c.isei_father=$a edu_m3=1) predict(outcome(2))   
margins rok, at(c.isei_father=$a edu_m3=1) predict(outcome(3))   
margins rok, at(c.isei_father=$a edu_m3=1) predict(outcome(4))   

quietly sum isei_father 
global b=`r(mean)'+`r(sd)'
display $b
margins rok, at(c.isei_father=$b edu_m3=3) predict(outcome(1))   
margins rok, at(c.isei_father=$b edu_m3=3) predict(outcome(2))   
margins rok, at(c.isei_father=$b edu_m3=3) predict(outcome(3))   
margins rok, at(c.isei_father=$b edu_m3=3) predict(outcome(4))   


