//Smooth Scrolling
$(function() {
  $('a[href*=#]:not([href=#])').click(function() {
    if (location.pathname.replace(/^\//,'') == this.pathname.replace(/^\//,'') && location.hostname == this.hostname) {

      var target = $(this.hash); 
      var hash = this.hash;
      target = target.length ? target : $('[name=' + this.hash.slice(1) +']');
      if (target.length) {
        $('html,body').animate({ scrollTop: target.offset().top }, 1000, function() {
		      location.hash = hash;  //attach the hash
	     	}); 
        return false;
      }
      
    }
  });
});

//Peklikvac rmeky
   
function init() {
    initTabs()
}             

function initTabs() {
    var tabLists = document.querySelectorAll(".zalozky");
    for (var i = 0; i < tabLists.length; i++) {
        var tabs = tabLists[i].querySelectorAll("input");
        var conts = tabLists[i].querySelectorAll(".zalozka-obsah");
       
        for (var j = 0; j < tabs.length; j++) {
            tabs[j].setAttribute("data-index", j)
            if (j == 0) {
                tabs[j].checked = true;
                conts[j].style.display = "block"
            }
            else {
                conts[j].style.display = "none"
            }
            tabs[j].addEventListener("click", showTab)
        }
    }
}
    
function showTab(evt) {
    var cil = evt. currentTarget;
    var index = parseInt(cil.getAttribute("data-index"));

    if (isNaN(index)) return;

    var conts = cil.parentNode.parentNode.querySelectorAll(".zalozka-obsah");

    for (var i = 0; i < conts.length; i++) {
        conts[i].style.display = (i == index) ? "block" : "none"

    }
}

window.addEventListener("load", init)