
function initGallery(evt) {
    //vsechno schovat
    
    var svgs = document.querySelectorAll("svg, g");
    for (var i = 0; i < svgs.length; i++) {
        svgs[i].style.display = "none";
    }
    
    var refs = document.querySelectorAll("[data-ref]");
    for (var i = 0; i < refs.length; i++) {
        refs[i].addEventListener("click", showPart);
    }
}

var actualSVG = null;
var actualPart = null;

function showPart(evt) {
    document.querySelector("aside.gallery").style.display = "block";
    
    var tag = evt.currentTarget;
    var ids = tag.getAttribute("data-ref").trim();
    ids = ids.replace(/\s+/g, " ");
    
    var vals = ids.split(" ");
    
    var newSVG = document.getElementById(vals[0]);
    if (!newSVG) {
        return;
    }
    
    if (actualSVG && actualSVG != newSVG) {
        actualSVG.style.display = "none";
        if (actualPart) {
            actualPart.style.display = "none";
            actualPart = null;
        }
            
    }
    
    actualSVG = newSVG;
    newSVG.style.display = "block";
    
    var newPart = document.getElementById(vals[1]);
    
    if (actualPart && actualPart != newPart) {
            actualPart.style.display = "none";
        }
    actualPart = newPart;
    newPart.style.display = "block";
}

function closeGallery() {
    document.querySelector("aside.gallery").style.display = "none";
    if (actualSVG) {
        actualSVG.style.display = "none";
    }
    if (actualPart) {
        actualPart.style.display = "none";
    }
    actualPart = null;
    actualSVG = null;
}

function showAllParts() {
    if (!actualSVG) return;
    
    var parts = actualSVG.querySelectorAll("g");
    for (var i = 0; i < parts.length; i++) {
        parts[i].style.display = "block";
    }
}

window.addEventListener("load", initGallery);