import numpy as np
import pylab
from lmfit import Minimizer, Parameters, fit_report

#nacteni dat do matice
data=np.loadtxt('Data.dat') 
xdata=data[:,0]
ydata=data[:,1]

#definice residualu: rozdilu fitovane funkce a dat
def residual(params, x, ydata):
    v = params.valuesdict()    #rozbaleni parametru do slovniku v
    e = v['eINF']-v['w']**2/(x*(x+1j*v['g']))  #dielektricka funkce
    N = e**0.5      #index lomu
    R=abs((N-1)/(N+1))**2 #vypocet odrazivosti
    return R-ydata    

#vytvoreni parametru a jejich startovacich hodnot. Mozno nastavit, zda se parametr fituje (vary=True) nebo ne 
params = Parameters()
params.add('eINF', value=9,vary=True)
params.add('w', value=1780,vary=True)
params.add('g', value=300,vary=True)

#fitovani
minner = Minimizer(residual, params, fcn_args=(xdata,ydata))
result = minner.minimize()

# calculate final result: data + residual
final = ydata + result.residual

# write error report, alternative result.params.pretty_print()
print(fit_report(result))

#ulozeni nafitovaneho spektra do souboru
FileData= open('Spektrum.dat', 'w')
for i in range(len(xdata)):
    print >>FileData, xdata[i],final[i]

#ulozeni statistiky do souboru
FileFit = open('Statistika.dat', 'w')
print >> FileFit, fit_report(result)

# vykresleni fitu na monitor

original= ydata+residual(params,xdata,ydata)
pylab.plot(xdata, original, 'g-')
pylab.plot(xdata, ydata, 'k-')
pylab.plot(xdata, final, 'r-')
pylab.show()

