#program na flexibilni fitovani optickych spekter s dynamickym poctem ruznymi oscilatoru. momentalne ma implemenovane lorenzovku, komplexni lorentzovku, realnou gaussovku, lorentzovku a Voightuv profil
import numpy as np
#import pylab
import matplotlib.pyplot as plt
from lmfit import Minimizer, Parameters, fit_report
#from lmfit.models import  VoigtModel
from scipy.special import wofz
import time

#nacteni dat do matice
data=np.loadtxt('Data.dat') 
xdata=data[:,0]
ydata=data[:,1]
global xdataGl,ydataGl
xdataGl=data[:,0]
ydataGl=data[:,1]

#definition of a gaussian function, pouze realne, pro fitovani ramana, luminiscence
def gaussian(x,p,w,g):
    return p/(g*2*np.pi) * np.exp(-(x-w)**2/(2*g**2))
    #return p/(g*2*math.pi) * (x-w)**2/(2*g)

#definition of normalized real Lorentzian, used for Raman or so
def LorentzianReal(x,p,w,g):
    return p*g/np.pi/((x-w)**2+g**2) 

#complex lorentzian, used for dielectric function
def lorentzian(x,p,w,g):
    return p**2/(w**2-x**2-1j*g*x) 

# lorentzian with complex spectral weight, assymetric oscillator
def LorentzianComplex(x,p,w,g,pc):
    return (p**2+1j*x*pc)/(w**2-x**2-1j*g*x) 

#  Voigt line shape at x with Lorentzian component HWHM gamma and Gaussian component HWHM alpha.
def Voight(x, p,w,alpha, gamma):  
    sigma = alpha / np.sqrt(2 * np.log(2))
    return p*np.real(wofz((x-w + 1j*gamma)/sigma/np.sqrt(2))) / sigma/np.sqrt(2*np.pi)

#definice residualu: rozdilu fitovane funkce a dat
def residual(params, x, ydata, NumberOscilators):
    v = params.valuesdict()    #rozpakovani vsech hodnot parametru do v
    #postupny vypocet fitovaci funkce pomoci ruznych prispevku (oscilatoru). Zacina se s nulovou hodnotou
    #print v    
    #raw_input("Press the <ENTER> key to continue...")    
    e=0.0
    for n in range(NumberOscilators["eINF"]):  e = e+ v['eINF']   # pridani konstanty eINF
    for n in range(NumberOscilators["Lorentz"]): #pridani Lorenztovych oscilatoru
        e=e+lorentzian(x,v["p"+str(n+1)],v["w"+str(n+1)],v["g"+str(n+1)])        
    for n in range(NumberOscilators["Gauss"]): #pridani Gaussovych oscilatoru
        e=e+gaussian(x,v["Gp"+str(n+1)],v["Gw"+str(n+1)],v["Gg"+str(n+1)])   
    for n in range(NumberOscilators["LorentzRe"]): #pridani realneho Lorentzova oscilatoru
        e=e+LorentzianReal(x,v["LRp"+str(n+1)],v["LRw"+str(n+1)],v["LRg"+str(n+1)])   
    for n in range(NumberOscilators["Voight"]): #pridani realneho Voightova oscilatoru
        e=e+Voight(x,v["Vp"+str(n+1)],v["Vw"+str(n+1)],v["Valpha"+str(n+1)],v["Vgamma"+str(n+1)])   
    for n in range(NumberOscilators["LorentzC"]): #pridani Lorenztovky s komplexni vahou
        e=e+LorentzianComplex(x,v["LCp"+str(n+1)],v["LCw"+str(n+1)],v["LCg"+str(n+1)],v["LCwc"+str(n+1)])   
    if NumberOscilators["DataType"]=="R":  #volba residualni funkce, zde pro odrazivost R
        N = e**0.5      #vypocet indexu lomu z dielektricke funkce
        R=abs((N-1)/(N+1))**2   # Odrazivost 
        Resid=R-ydata     # vypocet residualu: rozdil funkce a dat v pripade odrazivosti
        #raw_input("Press the <ENTER> key to continue...")    
    if NumberOscilators["DataType"]=="Raman": #volba residualni funkce, zde pro Ramana nebo luminiscenci
        Raman= e.real  # fitovana funkce v pripade Ramanskych nebo luminiscencnich dat, 
        Resid=Raman-ydata     # vypocet residualu: rozdil funkce a dat v pripade Ramana potreba odremovat
        #raw_input("Press the <ENTER> key to continue...")    
    return Resid   #vrati residual
    

def IsFitted(Str): # procedura na detekci zda se dany parametr fituje pomoci znaku "f"
	if (Str[0:1]=="F") or (Str[0:1]=="f"):
		Fit=False
		StrRed=float(Str[1:])
	else:
		Fit=True
		StrRed=float(Str)
	return 	Fit,StrRed  #vraci boolean Fit, ktery je false, jestli je to fixvany parametr,  a StrRed je hodnota parametru

#Generovani vstupnich parametru ze souboru, osetreni fixovani pomoci znaku "f" pred cislem
params = Parameters()  #zalozeni tridy parametru
NumberOscilators= {"DataType": "Raman","eINF": 0 , "Lorentz": 0,"Gauss": 0,"LorentzRe": 0,"Voight": 0, "LorentzC":0}   #slovnik, ktery obsahuje vsechny typy a pocet danych oscilatoru. Zacina se s nulovyma hodnotama
f = open('ParamsInput.dat', 'r')  #otevreni souboru se vstupnimi parametry
lines = f.readlines()    #nacteni souboru se vstupnimi parametry
lines = [x.strip('\t') for x in lines] # ocisteni od koncovych tabulatoru
for i in range(len(lines)):
    line=lines[i].split()   #rozdeleni radku na jednotive stringy
    if len(line)<2: break  #pokud je prazdna radka, tak konci cteni, za ni muzou byt nepouzite oscilatory
    if line[0]=='DataType':  #nacteni typu data, jako Raman, R (odrazivost) atp. 
        NumberOscilators["DataType"]= line[1]
    if line[0]=='eINF':  #zarazeni konstanty eINF
        NumberOscilators["eINF"]=NumberOscilators["eINF"]+1        # zvysuje pocet daneho oscilatoru v prehledu oscilatoru 
        Fitted,Val=IsFitted(line[1])        #nacteni hodnoty a osetreni znaku "f"
        params.add('eINF', value=Val,vary=Fitted)     #generace parametru, jeho hodnoty a toho, zda se fituje
    if line[0]=='Lorentz': #zarazeni Lorenztova oscilatoru
        NumberOscilators["Lorentz"]=NumberOscilators["Lorentz"]+1    # zvysuje pocet daneho oscilatoru v prehledu oscilatoru 
        OscNum=NumberOscilators["Lorentz"]        
        Fitted,Val=IsFitted(line[1])        
        params.add('p'+str(OscNum), value=Val,vary=Fitted)
        Fitted,Val=IsFitted(line[2])
        params.add('w'+str(OscNum), value=Val,vary=Fitted)
        Fitted,Val=IsFitted(line[3])
        params.add('g'+str(OscNum), value=Val,vary=Fitted)
    if line[0]=='Gauss': #zarazeni Gaussova oscilatoru
        NumberOscilators["Gauss"]=NumberOscilators["Gauss"]+1    # zvysuje pocet daneho oscilatoru v prehledu oscilatoru 
        OscNum=NumberOscilators["Gauss"]       
        Fitted,Val=IsFitted(line[1])        
        params.add('Gp'+str(OscNum), value=Val,vary=Fitted)
        Fitted,Val=IsFitted(line[2])
        params.add('Gw'+str(OscNum), value=Val,vary=Fitted)
        Fitted,Val=IsFitted(line[3])
        params.add('Gg'+str(OscNum), value=Val,vary=Fitted)
    if line[0]=='LorentzRe': #zarazeni realneho Lorentzova oscilatoru, pro Ramana
        NumberOscilators["LorentzRe"]=NumberOscilators["LorentzRe"]+1    # zvysuje pocet daneho oscilatoru v prehledu oscilatoru 
        OscNum=NumberOscilators["LorentzRe"]
        Fitted,Val=IsFitted(line[1])        
        params.add('LRp'+str(OscNum), value=Val,vary=Fitted)
        Fitted,Val=IsFitted(line[2])
        params.add('LRw'+str(OscNum), value=Val,vary=Fitted)
        Fitted,Val=IsFitted(line[3])
        params.add('LRg'+str(OscNum), value=Val,vary=Fitted)
    if line[0]=='Voight': #zarazeni realneho Vightova profilu pro Ramana, ma ctyri parametru
        NumberOscilators["Voight"]=NumberOscilators["Voight"]+1    # zvysuje pocet daneho oscilatoru v prehledu oscilatoru 
        OscNum=NumberOscilators["Voight"]
        Fitted,Val=IsFitted(line[1])        
        params.add('Vp'+str(OscNum), value=Val,vary=Fitted)
        Fitted,Val=IsFitted(line[2])
        params.add('Vw'+str(OscNum), value=Val,vary=Fitted)
        Fitted,Val=IsFitted(line[3])
        params.add('Valpha'+str(OscNum), value=Val,vary=Fitted)
        Fitted,Val=IsFitted(line[4])
        params.add('Vgamma'+str(OscNum), value=Val,vary=Fitted)
    if line[0]=='LorentzC': #zarazeni Lorentzova oscilatoru s komplexni vahou
        NumberOscilators["LorentzC"]=NumberOscilators["LorentzC"]+1    # zvysuje pocet daneho oscilatoru v prehledu oscilatoru 
        OscNum=NumberOscilators["LorentzC"]
        Fitted,Val=IsFitted(line[1])        
        params.add('LCp'+str(OscNum), value=Val,vary=Fitted)
        Fitted,Val=IsFitted(line[2])
        params.add('LCw'+str(OscNum), value=Val,vary=Fitted)
        Fitted,Val=IsFitted(line[3])
        params.add('LCg'+str(OscNum), value=Val,vary=Fitted)
        Fitted,Val=IsFitted(line[4])
        params.add('LCwc'+str(OscNum), value=Val,vary=Fitted)

        
#rutina ktera se vola po kazde iteraci a vykresluje staf fitovane fuknce,  Potrebuje pracovat s plt.ion(), 
def PlotCurrentInteration(params, it, resid,*args, **kws):
	lines=plt.plot(xdataGl, ydataGl+resid, 'b-',label='fitting')
	l = lines.pop(0)
	#plt.pause(0.01)  #pokud se toto pause zaremuje, tak to ploti priliz rychle
	print "iteration", it
	l.remove()
	return    

# vykresleni fitu na monitor.
plt.plot(xdataGl, ydataGl, 'k-',label='Data')
original= ydata+residual(params,xdata,ydata,NumberOscilators)
plt.plot(xdata, original, 'g-', label='Original model')
plt.legend(loc='upper right', shadow=False)

#plt.ion()
#plt.pause(0.05)
#plt.show()
#raw_input("Press <ENTER> to start fitting...")    

print "Start Fitting:"
TimeStart=time.time()

#fitovani
#minner = Minimizer(residual, params, fcn_args=(xdata,ydata,NumberOscilators), iter_cb=PlotCurrentInteration)  # u tohoto fitovani se zpousti za kazdou iteraci procedura PlotCurrentInteration. Mozno vykreslovat data behem fitovani
minner = Minimizer(residual, params, fcn_args=(xdata,ydata,NumberOscilators))  #fitovani bez prubezneho zobrazovani
result = minner.minimize()  #zde se uchovovaji vsechny vysledky fitovani
final = ydata + result.residual # finalni spektrum: data + residual

TimeEnd=time.time()    
print "Cas minimalizace: ", TimeEnd-TimeStart , " s"
print

#vytisteni statistiky na obrazovku a do souboru
print(fit_report(result,min_correl=0.5))   
FileFit = open('Statistika.dat', 'w')
print >> FileFit, fit_report(result,min_correl=0.5)   

#ulozeni nafitovaneho spektra do souboru
FileData= open('Spektrum.dat', 'w')
for i in range(len(xdata)):  print >>FileData, xdata[i],final[i]

#ulozeni obdrzenych parametru do souboru v tomsamem formatu jako ma ten vstupni soubor, mozno jednoduse zkopirovat
FileParOut = open('ParamsOutput.dat', 'w')
OutParams=result.params
def StrForm(strval):    #funkce na formatovani vystupniho cisla na 4 platne cislice a prevod do stringu
	return str("{0:.4g}".format(strval))
print >> FileParOut , "DataType\t" + NumberOscilators["DataType"]
for i in range(NumberOscilators["eINF"]): 
        word="eINF"+"\t"
        if OutParams["eINF"].vary==False:word=word+"f"          #pokud je parametr fixovany, priadava "f"
        word=word+StrForm(OutParams["eINF"].value)
        print >> FileParOut , word
for i in range(NumberOscilators["Lorentz"]): 
        word="Lorentz"+"\t"
        if OutParams['p'+str(i+1)].vary==False:word=word+"f"
        word=word+StrForm(OutParams['p'+str(i+1)].value)+"\t"
        if OutParams['w'+str(i+1)].vary==False:word=word+"f"
        word=word+StrForm(OutParams['w'+str(i+1)].value)+"\t"
        if OutParams['g'+str(i+1)].vary==False:word=word+"f"
        word=word+StrForm(OutParams['g'+str(i+1)].value)
        print >> FileParOut , word
for i in range(NumberOscilators["Gauss"]): 
        word="Gauss"+"\t"
        if OutParams['Gp'+str(i+1)].vary==False:word=word+"f"
        word=word+StrForm(OutParams['Gp'+str(i+1)].value)+"\t"
        if OutParams['Gw'+str(i+1)].vary==False:word=word+"f"
        word=word+StrForm(OutParams['Gw'+str(i+1)].value)+"\t"
        if OutParams['Gg'+str(i+1)].vary==False:word=word+"f"
        word=word+StrForm(OutParams['Gg'+str(i+1)].value)
        print >> FileParOut , word
for i in range(NumberOscilators["LorentzRe"]): 
        word="LorentzRe"+"\t"
        if OutParams['LRp'+str(i+1)].vary==False:word=word+"f"
        word=word+StrForm(OutParams['LRp'+str(i+1)].value)+"\t"
        if OutParams['LRw'+str(i+1)].vary==False:word=word+"f"
        word=word+StrForm(OutParams['LRw'+str(i+1)].value)+"\t"
        if OutParams['LRg'+str(i+1)].vary==False:word=word+"f"
        word=word+StrForm(OutParams['LRg'+str(i+1)].value)
        print >> FileParOut , word
for i in range(NumberOscilators["Voight"]): 
        word="Voight"+"\t"
        if OutParams['Vp'+str(i+1)].vary==False:word=word+"f"
        word=word+StrForm(OutParams['Vp'+str(i+1)].value)+"\t"
        if OutParams['Vw'+str(i+1)].vary==False:word=word+"f"
        word=word+StrForm(OutParams['Vw'+str(i+1)].value)+"\t"
        if OutParams['Valpha'+str(i+1)].vary==False:word=word+"f"
        word=word+StrForm(OutParams['Valpha'+str(i+1)].value)+"\t"
        if OutParams['Vgamma'+str(i+1)].vary==False:word=word+"f"
        word=word+StrForm(OutParams['Vgamma'+str(i+1)].value)
        print >> FileParOut , word
for i in range(NumberOscilators["LorentzC"]): 
        word="LorentzC"+"\t"
        if OutParams['LCp'+str(i+1)].vary==False:word=word+"f"
        word=word+StrForm(OutParams['LCp'+str(i+1)].value)+"\t"
        if OutParams['LCw'+str(i+1)].vary==False:word=word+"f"
        word=word+StrForm(OutParams['LCw'+str(i+1)].value)+"\t"
        if OutParams['LCg'+str(i+1)].vary==False:word=word+"f"
        word=word+StrForm(OutParams['LCg'+str(i+1)].value)+"\t"
        if OutParams['LCwc'+str(i+1)].vary==False:word=word+"f"
        word=word+StrForm(OutParams['LCwc'+str(i+1)].value)
        print >> FileParOut , word

FileFit.close()		
FileData.close()		
FileParOut.close()		
plt.plot(xdata, final, 'r-',label='Fitted model')
plt.legend(loc='upper right', shadow=False)
plt.show()
#raw_input("Press <ENTER> to finish")
