//Image Changer
function imgChanger(targetContainer, data) {
    this.targetContainer = document.getElementById(targetContainer);
    this.data = data;
    this.switchMemory = 0;
    this.actualImgID = 0;
    this.topButtons = [];
    this.belowButtons = [];
    this.init();
}

imgChanger.prototype.init = function() {
    var topCh = document.createElement("div");
    topCh.setAttribute("class", "topCh");
    var belowCh = document.createElement("div");
    belowCh.setAttribute("class", "belowCh");
    this.img = document.createElement("img");
    for (var i = 0; i < this.data.length; i++) {
//        this.switchMemory.push(0);
        var button = document.createElement("div");
        if (i == 0) {
            button.setAttribute("class", "change actual");
        } else {
            button.setAttribute("class", "change");
        }
        button.addEventListener("click", this.chImg(i, null, this));
        button.innerHTML = this.data[i][0];
        topCh.appendChild(button);
        this.topButtons.push(button);
    }
    this.targetContainer.appendChild(topCh);
    
    uniqueName = this.targetContainer.getAttribute("id");
    var button = createRadioElement(uniqueName, true, uniqueName + "_0");
    var label = crateLabelElement(uniqueName + "_0", "základní");
    button.addEventListener("click", this.chImg(null, 0, this));
    belowCh.appendChild(button);
    belowCh.appendChild(label);
    this.belowButtons.push(button);
    var button = document.createElement("div");
    var button = createRadioElement(uniqueName, false, uniqueName + "_1");
    var label = crateLabelElement(uniqueName + "_1", "popis");
    button.addEventListener("click", this.chImg(null, 1, this));
    belowCh.appendChild(button);
    belowCh.appendChild(label);
    this.belowButtons.push(button);
    var button = document.createElement("div");
    var button = createRadioElement(uniqueName, false, uniqueName + "_2");
    var label = crateLabelElement(uniqueName + "_2", "popisky");
    button.addEventListener("click", this.chImg(null, 2, this));
    belowCh.appendChild(button);
    belowCh.appendChild(label);
    this.belowButtons.push(button);
    this.targetContainer.appendChild(belowCh);
    this.targetContainer.appendChild(this.img);
    this.chImg(0, 0, this)();
}

imgChanger.prototype.chImg = function(imgID, kind, obj) {
    return function() {
        if (imgID != null && obj.actualImgID != imgID) {
            for (var i = 0; i < obj.topButtons.length; i++) {
                obj.topButtons[i].setAttribute("class", "change");
            }
            obj.topButtons[imgID].setAttribute("class", "change actual");
            obj.actualImgID = imgID;
        }
        for (var i = 0; i < obj.belowButtons.length; i++) {
            obj.belowButtons[i].checked = false;
        }
        var actkind = kind;
        if (kind == null) {
            actkind = obj.switchMemory;
        }
        obj.belowButtons[actkind].checked = true;
        if (actkind == 0) {
            obj.img.src = obj.data[obj.actualImgID][1];
            obj.switchMemory = 0;
        } else if (actkind == 1) {
            obj.img.src = obj.data[obj.actualImgID][1].substring(0, obj.data[obj.actualImgID][1].length - 4) + "_-_popis.jpg";
            obj.switchMemory = 1;
        } else {
            obj.img.src = obj.data[obj.actualImgID][1].substring(0, obj.data[obj.actualImgID][1].length - 4) + "_-_popisky.jpg";
            obj.switchMemory = 2;
        }
    }
}

function createRadioElement( name, checked, id ) {
    var radioInput;
    try {
        var radioHtml = '<input type="radio" class="radiob" name="' + name + '" id="' + id + '"';
        if ( checked ) {
            radioHtml += ' checked="checked"';
        }
        radioHtml += '/>';
        radioInput = document.createElement(radioHtml);
    } catch( err ) {
        radioInput = document.createElement('input');
        radioInput.setAttribute('type', 'radio');
        radioInput.setAttribute('name', name);
        radioInput.setAttribute('id', id);
        radioInput.setAttribute('class', "radiob");
        if ( checked ) {
            radioInput.setAttribute('checked', 'checked');
        }
    }

    return radioInput;
}

function crateLabelElement(forID, text) {
    var label = document.createElement("label");
    label.setAttribute("for", forID);
    label.setAttribute('class', "radiol");
    label.innerHTML = text;
    return label;
}