/*
 * Tomas Sedmik
 * ramm47@gmail.com
 * 08 05 2009
 */

#include <stdio.h>
#include <string.h>

enum states {start=0,I=1,IV=2,IX=3,II=4,III=5,V=6,VI=7,X=8,XX=9,XXX=10,
            XL=11,XC=12,L=13,C=14,CC=15,CCC=16,CD=17,CM=18,D=19,M=20,BH=21};

int table[22][7] = {
    /*input        I     V     X     L     C     D     M*/
    /*start*/ {    I,    V,    X,    L,    C,    D,    M},
    /*  I  */ {   II,   IV,   IX,   BH,   BH,   BH,   BH},
    /*  IV */ {   BH,   BH,   BH,   BH,   BH,   BH,   BH},
    /*  IX */ {   BH,   BH,   BH,   BH,   BH,   BH,   BH},
    /*  II */ {  III,   BH,   BH,   BH,   BH,   BH,   BH},
    /* III */ {   BH,   BH,   BH,   BH,   BH,   BH,   BH},
    /*   V */ {   VI,   BH,   BH,   BH,   BH,   BH,   BH},
    /*  VI */ {   II,   BH,   BH,   BH,   BH,   BH,   BH},
    /*   X */ {    I,    V,   XX,   XL,   XC,   BH,   BH},
    /*  XX */ {    I,    V,  XXX,   BH,   BH,   BH,   BH},
    /* XXX */ {    I,    V,   BH,   BH,   BH,   BH,   BH},
    /*  XL */ {    I,    V,   BH,   BH,   BH,   BH,   BH},
    /*  XC */ {    I,    V,   BH,   BH,   BH,   BH,   BH},
    /*   L */ {    I,    V,    X,   BH,   BH,   BH,   BH},
    /*   C */ {    I,    V,    X,    L,   CC,   CD,   CM},
    /*  CC */ {    I,    V,    X,    L,  CCC,   BH,   BH},
    /* CCC */ {    I,    V,    X,    L,   BH,   BH,   BH},
    /*  CD */ {    I,    V,    X,    L,   BH,   BH,   BH},
    /*  CM */ {    I,    V,    X,    L,   BH,   BH,   BH},
    /*   D */ {    I,    V,    X,    L,    C,   BH,   BH},
    /*   M */ {    I,    V,    X,    L,    C,    D,    M},
    /*  BH */ {   BH,   BH,   BH,   BH,   BH,   BH,   BH}
};

int CheckEra(const char* input) {

    enum states state;
    int i;
    int inputChar;

    state = start;
    for (i=0;i<strlen(input)-1;i++) {

        /* input char. If has wrong format end */
        switch (input[i]) {

            case 'I' : { inputChar = 0; break;}
            case 'V' : { inputChar = 1; break;}
            case 'X' : { inputChar = 2; break;}
            case 'L' : { inputChar = 3; break;}
            case 'C' : { inputChar = 4; break;}
            case 'D' : { inputChar = 5; break;}
            case 'M' : { inputChar = 6; break;}
            default  : return 1;
        }

        state = table[state][inputChar];

        /* state is black hole ... unacceptable state */
        if (state==BH) return 2;
    }

    return 0;
}

int main() {

    char input[256];

    printf("Zadejte letopocet (rimskymi cislicemi): ");
    fgets (input,256,stdin);

    if (CheckEra(input)==0) printf("Valid\n");
    else printf("Wrong!\n");

    return 0;
}
