/*
 * Tomas Sedmik
 * ramm47@gmail.com
 * 15 04 2009
 */
#include "onewaylist.h"

/*
 * Deallocation memory, call as reference
 */
int Destroy(owl* head) {

    owl temp;

    while ((*head)!=NULL) {
        temp = *head;
        *head = temp->p_list;
        free(temp);
    }
    free(*head);

    return 0;
}


/*
 * Is list empty?
 */
int IsEmpty(const owl head) {

    return (head==NULL) ? 1 : 0;
}


/*
 * returns count of items in the list
 */
int Length(owl head) {

    if (IsEmpty(head)) return 0;

    int count=1;
    while(head->p_list!=NULL) {

        count++;
        head = head->p_list;
    }

    return count;
}


/*
 * Insert item on begin of the list. Call as reference.
 */
int Push(owl* head, ListData item) {

    owl InsertData;
    InsertData = (OneWayList*)malloc(sizeof(OneWayList));

    InsertData->item = item;
    InsertData->p_list = *head;
    *head = InsertData;

    return 0;
}


/*
 * insert item on end of the list
 */
int PushBack(owl* head, ListData item) {

    owl temp;
    owl newvalue;
    owl temphead = *head;

    if (*head==NULL) {

        Push(head,item);
        return 0;
    }
    
    while (*head!=NULL) {

        temp = *head;
        *head = (*head)->p_list;
    }

    newvalue = (OneWayList*)malloc(sizeof(OneWayList));
    newvalue->item = item;
    newvalue->p_list = NULL;

    temp->p_list = newvalue;
    *head = temphead;

    return 0;
}


/*
 * remove top element. Call as reference
 */
int Pop(owl* head) {

    owl temp;

    temp = *head;
    if ((*head)->p_list==NULL) *head = NULL;
    else *head = (*head)->p_list;
    free(temp);

    return 0;
}


/*
 * returns top value of the list
 */
ListData Top(owl head) {

    return head->item;
}


/*
 * returns position presence of searchItem. If search item isn't in the list
 * return -1
 */
int Find(owl head, ListData searchItem) {

    int position = -1;
    int currPosition = 0;

    while((head!=NULL)&&(position==-1)) {

        if (head->item==searchItem) position = currPosition;
        currPosition++;
        head = head->p_list;
    }

    return position;
}


/*
 * detele entity on position. Call as reference
 */
int Delete(owl* head,int position) {

    if (position==0) Pop(head);
    else {

        owl temp;
        owl temp2;

        temp = *head;
        int i;
        for (i=0;i<position-1;i++)
            temp = temp->p_list;

        temp2 = temp->p_list;
        temp->p_list = temp2->p_list;
        free(temp2);
    }

    return 0;
}


/*
 * insert value on position. Call as reference.
 */
int Insert(owl* head, int position, ListData item) {

    if (position==0) {

        owl InsertData;
        InsertData = (OneWayList*)malloc(sizeof(OneWayList));

        InsertData->item = item;
        InsertData->p_list = *head;
        *head = InsertData;
    }
    else {

        owl temp;
        owl temp2;

        temp = *head;
        int i;
        for (i=0;i<position-1;i++)
            temp = temp->p_list;

        temp2 = (OneWayList*)malloc(sizeof(OneWayList));
        temp2->item = item;
        temp2->p_list = temp->p_list;
        temp->p_list = temp2;
    }

    return 0;
}

/*
 * returns item on position.
 */
ListData GetItem(owl head, int position) {

    int i;

    for (i=0;i<position;i++)
        head = head->p_list;

    return head->item;
}


/*
 * change value on position
 */
int ChangeValue(owl head, int position, ListData value) {

    owl temp;

    temp = head;
    int i;
    for (i=0;i<position;i++)
        temp = temp->p_list;
    temp->item = value;

    return 0;
}


/*
 * returns next element
 */
ListData Next(owl head) {

    head = head->p_list;
    return head->item;
}


/*
 * return pointer on next element
 */
owl NextAsPointer(owl head) {

    return head->p_list;
}
