/*
 * Tomas Sedmik
 * ramm47@gmail.com
 * 16 04 2009
 */
#include "twowayslist.h"


/*
 * Deallocation memory
 */
int Destroy(twl* head) {

    twl temp;

    while ((*head)!=NULL) {
        temp = *head;
        *head = temp->pf_list;
        free(temp);
    }
    free(*head);

    return 0;
}


/*
 * Is list empty?
 */
int IsEmpty(const twl head) {

    return (head==NULL) ? 1 : 0;
}


/*
 * returns count of items in the list
 */
int Length(twl head) {

    if (IsEmpty(head)) return 0;

    int count=1;
    while(head->pf_list!=NULL) {

        count++;
        head = head->pf_list;
    }

    return count;
}


/*
 * Insert item on begin of the list
 */
int Push(twl* head, ListData item) {

    twl InsertData;
    InsertData = (TwoWaysList*)malloc(sizeof(TwoWaysList));

    InsertData->item = item;
    InsertData->pf_list = *head;
    InsertData->pb_list = NULL;
    *head = InsertData;

    return 0;
}


/*
 * insert item on end of the list
 */
int PushBack(twl* head, ListData item) {

    twl temp;
    twl newitem;

    if (*head==NULL) {

        Push(head,item);
        return 0;
    }

    temp = *head;
    while (temp->pf_list!=NULL)
        temp = temp->pf_list;

    newitem = (TwoWaysList*)malloc(sizeof(TwoWaysList));
    newitem->item = item;
    newitem->pf_list = NULL;
    newitem->pb_list = temp;

    temp->pf_list = newitem;

    return 0;
}


/*
 * delete top value of the list
 */
int Pop(twl* head) {

    twl temp;

    temp = *head;
    if ((*head)->pf_list==NULL) *head = NULL;
    else *head = (*head)->pf_list;
    free(temp);

    return 0;
}


/*
 * returns first value of the list
 */
ListData Top(twl head) {

    return head->item;
}


/*
 * returns position presence of searchItem. If search item isn't in the list
 * return -1
 */
int Find(twl head, ListData searchItem) {

    int position = -1;
    int currPosition = 0;

    while((head!=NULL)&&(position==-1)) {

        if (head->item==searchItem) position = currPosition;
        currPosition++;
        head = head->pf_list;
    }

    return position;
}


/*
 * detele entity on position
 */
int Delete(twl* head,int position) {

    if (position==0) {

        twl temp;

        temp = *head;
        if ((*head)->pf_list==NULL) *head = NULL;
        else *head = (*head)->pf_list;
        free(temp);
    }
    else {

        twl temp;
        twl temp2;

        temp = *head;
        int i;
        for (i=0;i<position-1;i++)
            temp = temp->pf_list;

        temp2 = temp->pf_list;
        temp->pf_list = temp2->pf_list;
        if (temp2->pf_list!=NULL) {

            temp = temp2->pf_list;
            temp->pb_list = temp2->pb_list;
        }

        free(temp2);
    }

    return 0;
}


/*
 * insert value on position
 */
int Insert(twl* head, int position, ListData item) {

    if (position==0) {

        twl InsertData;
        InsertData = (TwoWaysList*)malloc(sizeof(TwoWaysList));

        InsertData->item = item;
        InsertData->pf_list = *head;
        InsertData->pb_list = NULL;
        *head = InsertData;
    }
    else {

        twl temp;
        twl temp2;

        temp = *head;
        int i;
        for (i=0;i<position-1;i++)
            temp = temp->pf_list;

        temp2 = (TwoWaysList*)malloc(sizeof(TwoWaysList));
        temp2->item = item;
        temp2->pf_list = temp->pf_list;
        temp2->pb_list = temp;
        temp->pf_list = temp2;
    }

    return 0;
}

/*
 * returns item on position.  If's position out of range returns first item
 */
ListData GetItem(twl head, int position) {

    ListData item = head->item;

    int i;
    for (i=0;i<position;i++)
        head = head->pf_list;
    if (head!=NULL) item = head->item;

    return item;
}


/*
 * change value on position
 */
int ChangeValue(twl head, int position, ListData value) {

    twl temp;

    temp = head;
    int i;
    for (i=0;i<position;i++)
        temp = temp->pf_list;
    temp->item = value;

    return 0;
}


/*
 * returns next element
 */
ListData Next(twl head) {

    head = head->pf_list;
    return head->item;
}


/*
 * returns previos element
 */
ListData Previous(twl head) {

    head = head->pf_list;
    return head->item;
}


/*
 * return pointer on next element
 */
twl NextAsPointer(twl head) {

    return head->pf_list;
}


/*
 * return pointer on previous element
 */
twl PreviousAsPointer(twl head) {

    return head->pb_list;
}
