/*
 * Tomas Sedmik
 * ramm47@gmail.com
 * 16 04 2009
 */
#ifndef _TWOWAYSLIST_H
#define	_TWOWAYSLIST_H

#include <stdio.h>
#include <stdlib.h>

/* List data type */
typedef int ListData;


/* Definition two ways list */
typedef struct _TwoWaysList{

    ListData item;
    struct _TwoWaysList* pf_list;
    struct _TwoWaysList* pb_list;
} TwoWaysList;

typedef TwoWaysList* twl;


/* call as reference */
int Destroy(twl* head);
int Push(twl* head, ListData item);
int Pop(twl* head);
int Delete(twl* head,int position);
int Insert(twl* head, int position, ListData item);
int PushBack(twl* head, ListData item);

/* normal call */
int IsEmpty(const twl head);
int Length(twl head);
ListData Top(twl head);
int Find(twl head, ListData searchItem);
ListData GetItem(twl head, int position);
int ChangeValue(twl head, int position, ListData value);
ListData Next(twl head);
ListData Previous(twl head);
twl NextAsPointer(twl head);
twl PreviousAsPointer(twl head);

#endif	/* _TWOWAYSLIST_H */
