/*
 * Tomas Sedmik
 * ramm47@gmail.com
 * 17 04 2009
 */
#include "hash.h"

int HashTableHash(char* input) {

    return (input[0]*2+strlen(input)*3)%HASHTABLE_SIZE;
}


void LinearHashTableInit(linearhashtable* table) {

    int i;

    for (i=0;i<HASHTABLE_SIZE;i++)
        *table[i] = "";
}


/*
 * return 1 if hashtable is full
 */
int LinearHashTableHashAndStore(linearhashtable* table, char* input) {

    int isSpace = 1;
    int hash = HashTableHash(input);

    if (!strcmp(*table[hash],"")) {

        *table[hash]=input;
        isSpace = 0;
    }
    else {

        /* Collision ... linear execute */
        int i = hash+1;
        while (i!=hash) {

            if (i==HASHTABLE_SIZE) i = 0;
            if (i==hash) break;
            if (!strcmp(*table[i],"")) {

                *table[i]=input;
                isSpace = 0;
                break;
            }
            else i++;
        }
    }

    return isSpace;
}


int LinearHashTableWriteOut(linearhashtable* table){

    int i;

    for (i=0;i<HASHTABLE_SIZE;i++)
        printf("%d. - %s\n",i,*table[i]);

    return 0;
}

char* LinearHashTableGetItem(linearhashtable* table, int position) {

    return *table[position];
}
