#include <stdio.h>
#include <stdlib.h>
#include "hash.h"

#define SEARCH_VALUE "Yoda"

int main() {

    linearhashtable table;
    int i;

    char* input[] = {"Andromeda","Orion","Pegas","Lyra","Kasiopea","Velky vuz",
    "Nebula","Skywalker","ObiWan","Luke","Leia","Han Solo","Yoda","Mace Windu",
    "Aribeth","Jar Jar Bings","Padme Amidala","Alya Secura"};

    /* Linear hash table */
    {        
        LinearHashTableInit(&table);

        for (i=0;i<18;i++) 
            if (LinearHashTableHashAndStore(&table,input[i])==1) {

                printf("Hashovaci tabulka je plna ... nelze vice vkladat!\n");
                break;
            }
        
        LinearHashTableWriteOut(&table);
        printf("\n");

        /* search item in hash table */
        char* searchValue = SEARCH_VALUE;
        int hash = HashTableHash(searchValue);
        printf("hledany retezec je %s, s hashem %i\n", searchValue, hash);

        if (LinearHashTableGetItem(&table,hash)==searchValue)
            printf("Hledany prvek nalezen v 1. kroku\n");
        else {

            int count = 1;
            i = hash+1;

            while (i!=hash) {

                if (i==HASHTABLE_SIZE) i = 0;
                if (strcmp(LinearHashTableGetItem(&table,i),"")==0) {

                    printf("Hledany prvek neexistuje (po %i. kroku)\n", count+1);
                    break;
                }
                else {

                    count++;
                    if (i==HASHTABLE_SIZE) i = 0;
                    if (i==hash) break;
                    if (strcmp(LinearHashTableGetItem(&table,i),searchValue)==0) {

                        printf("Hledany prvek nalezen v %i. kroku\n", count);
                        break;
                    }
                    else i++;
                }
            }
        }
        

        
    }

    return 0;
}

