/*
 * Tomas Sedmik
 * ramm47@gmail.com
 * 18 04 2009
 */
#include "graphalgorithm.h"

int ArrayMatrixDFS(arraymatrix* matrix, int start, int end) {

    /* init */
    if ((end>MATRIX_COLS)||(start>MATRIX_ROWS)) return 2;

    int temp[MATRIX_ROWS];
    int i;

    for (i=0;i<MATRIX_ROWS;i++)
        temp[i] = -1;

    /* searching */
    owl Stack = NULL;

    temp[start] = 1;
    Push(&Stack,start);

    while(!IsEmpty(Stack)) {

        ListData item = Top(Stack);
        Pop(&Stack);

        for (i=0;i<MATRIX_COLS;i++) {

            MATRIX_DATA data = ArrayMatrixGetItem(matrix,item,i);
            if (data!=-1) {

                if (i==end) return 0;
                if (temp[i]==-1) {

                    temp[i]=1;
                    Push(&Stack,i);
                }
            }
        }
    }

    Destroy(&Stack);

    return 1;
}


int ArrayMatrixBFS(arraymatrix* matrix, int start, int end) {

    /* init */
    if ((end>MATRIX_COLS)||(start>MATRIX_ROWS)) return 2;
    
    int temp[MATRIX_ROWS];
    int i;

    for (i=0;i<MATRIX_ROWS;i++)
        temp[i] = -1;

    /* searching */
    owl front = NULL;

    temp[start] = 1;
    PushBack(&front,start);

    while(!IsEmpty(front)) {

        ListData item = Top(front);
        Pop(&front);

        for (i=0;i<MATRIX_COLS;i++) {

            MATRIX_DATA data = ArrayMatrixGetItem(matrix,item,i);
            if (data!=-1) {

                if (i==end) return 0;
                if (temp[i]==-1) {

                    temp[i]=1;
                    PushBack(&front,i);
                }
            }
        }
    }

    Destroy(&front);

    return 1;
}


int ListArrayMatrixDFS(listarraymatrix* matrix, int start, int end) {

    /* init */
    if ((end>MATRIX_COLS)||(start>MATRIX_ROWS)) return 2;

    int temp[MATRIX_ROWS];
    int i;

    for (i=0;i<MATRIX_ROWS;i++)
        temp[i] = -1;

    /* searching */
    owl Stack = NULL;

    temp[start] = 1;
    Push(&Stack,start);

    while(!IsEmpty(Stack)) {

        ListData item = Top(Stack);
        Pop(&Stack);

        for (i=0;i<MATRIX_COLS;i++) {

            MATRIX_DATA data = ListArrayMatrixGetItem(matrix,item,i);
            if (data!=-1) {

                if (i==end) return 0;
                if (temp[i]==-1) {

                    temp[i]=1;
                    Push(&Stack,i);
                }
            }
        }
    }

    Destroy(&Stack);

    return 1;
}

int ListArrayMatrixBFS(listarraymatrix* matrix, int start, int end) {

    /* init */
    if ((end>MATRIX_COLS)||(start>MATRIX_ROWS)) return 2;

    int temp[MATRIX_ROWS];
    int i;

    for (i=0;i<MATRIX_ROWS;i++)
        temp[i] = -1;

    /* searching */
    owl front = NULL;

    temp[start] = 1;
    PushBack(&front,start);

    while(!IsEmpty(front)) {

        ListData item = Top(front);
        Pop(&front);

        for (i=0;i<MATRIX_COLS;i++) {

            MATRIX_DATA data = ListArrayMatrixGetItem(matrix,item,i);
            if (data!=-1) {

                if (i==end) return 0;
                if (temp[i]==-1) {

                    temp[i]=1;
                    PushBack(&front,i);
                }
            }
        }
    }

    Destroy(&front);

    return 1;
}
