/* 
 * Tomas Sedmik
 * ramm47@gmail.com
 * 26 04 2009
 */

#ifndef _MATRIXES_H
#define	_MATRIXES_H

#include <stdio.h>
#include <stdlib.h>

#define MATRIX_DATA int
#define MATRIX_ROWS 20
#define MATRIX_COLS 20
#define DATA_COUNT 400

/* List data type */
typedef MATRIX_DATA matrixdata;

/* Definition one way list */
typedef struct _MatrixList{

        matrixdata item;
        int position;
        struct _MatrixList* p_list;

} MatrixList;

typedef MatrixList* ml;

typedef struct {

    MATRIX_DATA matrix[MATRIX_ROWS][MATRIX_COLS];

}arraymatrix;


typedef struct {

    ml matrix[MATRIX_ROWS];

}listarraymatrix;


typedef struct _listoflistsmatrix{

    int position;
    struct _MatrixList* matrixcols;
    struct _listoflistsmatrix* p_list;
    
}listoflistsmatrix;

typedef listoflistsmatrix* lolmatrix;

/* array matrix */
int ArrayMatrixInit(arraymatrix* matrix);
int ArrayMatrixRandomFill(arraymatrix* matrix);
MATRIX_DATA ArrayMatrixGetItem(arraymatrix* matrix, int posx, int posy);

/* matrix representive as array of onewaylist */
int ListArrayMatrixInit(listarraymatrix* matrix);
int ListArrayMatrixRandomFill(listarraymatrix* matrix);
MATRIX_DATA ListArrayMatrixGetItem(listarraymatrix* matrix, int posx, int posy);
int ListArrayMatrixFindPosition(listarraymatrix* matrix, int posx, int posy);
int ListArrayMatrixDestroy(listarraymatrix* matrix);

/* matrix representice as list of onewaylists */
int ListOfListsMatrixRandomFill(lolmatrix* matrix);
MATRIX_DATA ListOfListsMatrixGetItem(lolmatrix matrix, int posx, int posy);
int ListOfListsMatrixFindPosition(lolmatrix matrix, int posx, int posy);
int ListOfListsMatrixDestroy(lolmatrix* matrix);

int listoflistsPush(lolmatrix* head, int position);
ml listoflistsGetList(lolmatrix head, int position);
int listoflistsFindPosition(lolmatrix head, int pos);

/* one way list function for matrixes */
int MatrixesPush(ml* head, matrixdata item, int position);
int MatrixesFindPosition(ml head, int pos);
matrixdata MatrixesGetItem(ml head, int position);
int MatrixesDestroy(ml* head);

#endif	/* _MATRIXES_H */

