#include <stdio.h>
#include <stdlib.h>
#include "graphalgorithm.h"

void GetInput(int* start, int* end) {

    char line[256];

    printf("Zadej vychozi pozici v grafu: ");
    fgets (line,256,stdin);
    *start = atoi (line);

    printf("Zadejte hledany uzel v grafu: ");
    fgets (line,256,stdin);
    *end = atoi (line);
}


int ArrayMatrixQuery(arraymatrix matrix) {

    int start, end;
    int accessible;

    GetInput(&start,&end);

    /* deep first search */
    accessible = ArrayMatrixDFS(&matrix,start,end);

    /* brandth first search */
    /*
     * accessible = ArrayMatrixBFS(&matrix,start,end);
     */

    if (accessible!=0)
        printf("Hledany uzel neni z vychozi pozice dosazitelny.\n");
    else
        printf("Hledany uzel je dosazitelny.\n");

    return 0;
}


int ListArrayMatrixQuery(listarraymatrix matrix) {

    int start, end;
    int accessible;

    GetInput(&start,&end);

    /* deep first search */
    accessible = ListArrayMatrixDFS(&matrix,start,end);

    /* brandth first search */
    /*
     * accessible = ListArrayMatrixBFS(&matrix,start,end);
     */

    if (accessible!=0)
        printf("Hledany uzel neni z vychozi pozice dosazitelny.\n");
    else
        printf("Hledany uzel je dosazitelny.\n");

    return 0;
}


int main() {

    /* array matrix */
    {
        arraymatrix matrix;

        printf("Matice reprezentovana polem\n");
        ArrayMatrixInit(&matrix);
        ArrayMatrixRandomFill(&matrix);
        ArrayMatrixQuery(matrix);
    }

    /* matrix as array of onewaylist */
    {
        listarraymatrix matrix;

        printf("\nMatice reprezentovana polem spojovych seznamu\n");
        ListArrayMatrixInit(&matrix);
        ListArrayMatrixRandomFill(&matrix);
        ListArrayMatrixQuery(matrix);
        ListArrayMatrixDestroy(&matrix);
    }

    return 0;
}

