#include <stdio.h>
#include <stdlib.h>
#include <limits.h>
#include "graphalgorithm.h"


#define INFINITY INT_MAX/2

int main() {

    /* Array Matrix */
    {
        arraymatrix matrix;

        /* Random fill matrix */
        int i,j;

        for (i=0;i<MATRIX_ROWS;i++)
        for (j=0;j<MATRIX_COLS;j++) {

            int temp = rand()%15;
            if ((temp<=10)&&(temp!=0))
                ArrayMatrixSetValue(&matrix,i,j,temp);
            else ArrayMatrixSetValue(&matrix,i,j,INFINITY);
        }

        /* Write out matrix */
        for (i=0;i<MATRIX_ROWS;i++) {

            for (j=0;j<MATRIX_COLS;j++) {

                MATRIX_DATA temp = ArrayMatrixGetItem(&matrix,i,j);

                temp != INFINITY ? printf("%d ",temp) :
                printf("- ");
            }
            printf("\n");
        }
        printf("\n");

        /* Floyd Warshall algorithm */
        ArrayMatrixFloydWarshall(&matrix);

        /* Write out matrix */
        for (i=0;i<MATRIX_ROWS;i++) {

            for (j=0;j<MATRIX_COLS;j++) {

                MATRIX_DATA temp = ArrayMatrixGetItem(&matrix,i,j);

                temp != INFINITY ? printf("%d ",temp) :
                printf("- ");
            }
            printf("\n");
        }
        printf("\n");
    }


    /* ListArray Matrix */
    {
        listarraymatrix matrix;

        ListArrayMatrixInit(&matrix);
        
        /* Random fill matrix */
        int i,j;

        for (i=0;i<MATRIX_ROWS;i++)
        for (j=0;j<MATRIX_COLS;j++) {

            int temp = rand()%15;
            if ((temp<=10)&&(temp!=0))
                ListArrayMatrixSetValue(&matrix,i,j,temp);
            else ListArrayMatrixSetValue(&matrix,i,j,INFINITY);
        }

        /* Write out matrix */
        for (i=0;i<MATRIX_ROWS;i++) {

            for (j=0;j<MATRIX_COLS;j++) {

                MATRIX_DATA temp = ListArrayMatrixGetItem(&matrix,i,j);

                temp != INFINITY ? printf("%d ",temp) :
                printf("- ");
            }
            printf("\n");
        }
        printf("\n");

        /* Floyd Warshall algorithm */
        ListArrayMatrixFloydWarshall(&matrix);

        /* Write out matrix */
        for (i=0;i<MATRIX_ROWS;i++) {

            for (j=0;j<MATRIX_COLS;j++) {

                MATRIX_DATA temp = ListArrayMatrixGetItem(&matrix,i,j);

                temp != INFINITY ? printf("%d ",temp) :
                printf("- ");
            }
            printf("\n");
        }
        printf("\n");
    }

    return 0;
}
