/*
 * Tomas Sedmik
 * ramm47@gmail.com
 * 20 04 2009
 */
#include "graphalgorithm.h"

int ArrayMatrixDFS(arraymatrix* matrix, int start, int end) {

    /* init */
    if ((end>MATRIX_COLS)||(start>MATRIX_ROWS)) return 2;

    int temp[MATRIX_ROWS];
    int i;

    for (i=0;i<MATRIX_ROWS;i++)
        temp[i] = -1;

    /* searching */
    owl Stack = NULL;

    temp[start] = 1;
    Push(&Stack,start);

    while(!IsEmpty(Stack)) {

        ListData item = Top(Stack);
        Pop(&Stack);

        for (i=0;i<MATRIX_COLS;i++) {

            MATRIX_DATA data = ArrayMatrixGetItem(matrix,item,i);
            if (data!=-1) {

                if (i==end) return 0;
                if (temp[i]==-1) {

                    temp[i]=1;
                    Push(&Stack,i);
                }
            }
        }
    }

    Destroy(&Stack);

    return 1;
}


int ArrayMatrixBFS(arraymatrix* matrix, int start, int end) {

    /* init */
    if ((end>MATRIX_COLS)||(start>MATRIX_ROWS)) return 2;

    int temp[MATRIX_ROWS];
    int i;

    for (i=0;i<MATRIX_ROWS;i++)
        temp[i] = -1;

    /* searching */
    owl front = NULL;

    temp[start] = 1;
    PushBack(&front,start);

    while(!IsEmpty(front)) {

        ListData item = Top(front);
        Pop(&front);

        for (i=0;i<MATRIX_COLS;i++) {

            MATRIX_DATA data = ArrayMatrixGetItem(matrix,item,i);
            if (data!=-1) {

                if (i==end) return 0;
                if (temp[i]==-1) {

                    temp[i]=1;
                    PushBack(&front,i);
                }
            }
        }
    }

    Destroy(&front);

    return 1;
}


int ArrayMatrixFloydWarshall(arraymatrix* matrix) {

    int i,j,k;

    for (i=0;i<MATRIX_ROWS;i++)
        for (j=0;j<MATRIX_COLS;j++)
            for (k=0;k<MATRIX_COLS;k++) {

                MATRIX_DATA x,y,z;

                x = ArrayMatrixGetItem(matrix,i,j);
                y = ArrayMatrixGetItem(matrix,i,k);
                z = ArrayMatrixGetItem(matrix,k,j);
                if (x>(y+z))
                    ArrayMatrixSetValue(matrix,i,j,y+z);
                else ArrayMatrixSetValue(matrix,i,j,x);
            }

    return 0;
}


int ArrayMatrixDijkstra(arraymatrix* matrix, int start, int end) {
    
    /* values is out of range => END */
    if ((start>MATRIX_ROWS)||(end>MATRIX_COLS)||(start<0)||(end<0))
        return 1;
    
    /* matrix is NULL => END */
    if (matrix==NULL) return 2;
    
    ml nodeList = NULL;
    nodesInfoForDijkstra nodes[MATRIX_ROWS];
    int i;
    
    /* set initial values for nodedistance */
    for (i=0;i<MATRIX_ROWS;i++) {

        nodes[i].distance = INFINITY;
        nodes[i].previous = INFINITY;

        /* set unworked nodes */
        MatrixesPush(&nodeList,INFINITY,i);
    }    

    nodes[start].distance = 0;
    nodes[start].previous = start;
    MatrixesChangeValue(&nodeList,0,start);

    /* Main loop */
    while (!MatrixesIsEmpty(nodeList)) {

        /* if's looking node worked break */
        if (MatrixesFindPosition(nodeList,end)==1) break;

        /* looking for node with minimal distance */
        ml temp = nodeList;
        int currentNode = temp->position;
        int minimalDistance = temp->item;

        temp = temp->p_list;
        while (temp!=NULL) {

            if (temp->item<minimalDistance) {

                currentNode = temp->position;
                minimalDistance = temp->item;
            }

            temp = temp->p_list;
        }

        /* Looking for unvisited neighbours */
        for (i=0;i<MATRIX_COLS;i++) {

            if ((matrix->matrix[currentNode][i]!=-1)&&
                    (MatrixesFindPosition(nodeList,i)==0)) {

                if (nodes[i].distance>nodes[currentNode].distance+
                        matrix->matrix[currentNode][i]) {

                    nodes[i].distance = nodes[currentNode].distance +
                    matrix->matrix[currentNode][i];
                    nodes[i].previous = currentNode;
                    MatrixesChangeValue(&nodeList,(nodes[currentNode].distance +
                    matrix->matrix[currentNode][i]),i);
                }
            }
        }

        /* Delete current node as worked */
        MatrixesDelete(&nodeList,currentNode);
    }

    /* Write out Path */
    i = 0;
    int currentNode = end;
    printf("%i -> ",end);
    while (currentNode!=start) {

        currentNode = nodes[currentNode].previous;
        i = i + nodes[currentNode].distance;
        printf("%i -> ",currentNode);
    }
    printf("Delka cesty je: %i\n",i);

    return 0;
}


int ListArrayMatrixDFS(listarraymatrix* matrix, int start, int end) {

    /* init */
    if ((end>MATRIX_COLS)||(start>MATRIX_ROWS)) return 2;

    int temp[MATRIX_ROWS];
    int i;

    for (i=0;i<MATRIX_ROWS;i++)
        temp[i] = -1;

    /* searching */
    owl Stack = NULL;

    temp[start] = 1;
    Push(&Stack,start);

    while(!IsEmpty(Stack)) {

        ListData item = Top(Stack);
        Pop(&Stack);

        for (i=0;i<MATRIX_COLS;i++) {

            MATRIX_DATA data = ListArrayMatrixGetItem(matrix,item,i);
            if (data!=-1) {

                if (i==end) return 0;
                if (temp[i]==-1) {

                    temp[i]=1;
                    Push(&Stack,i);
                }
            }
        }
    }

    Destroy(&Stack);

    return 1;
}


int ListArrayMatrixBFS(listarraymatrix* matrix, int start, int end) {

    /* init */
    if ((end>MATRIX_COLS)||(start>MATRIX_ROWS)) return 2;

    int temp[MATRIX_ROWS];
    int i;

    for (i=0;i<MATRIX_ROWS;i++)
        temp[i] = -1;

    /* searching */
    owl front = NULL;

    temp[start] = 1;
    PushBack(&front,start);

    while(!IsEmpty(front)) {

        ListData item = Top(front);
        Pop(&front);

        for (i=0;i<MATRIX_COLS;i++) {

            MATRIX_DATA data = ListArrayMatrixGetItem(matrix,item,i);
            if (data!=-1) {

                if (i==end) return 0;
                if (temp[i]==-1) {

                    temp[i]=1;
                    PushBack(&front,i);
                }
            }
        }
    }

    Destroy(&front);

    return 1;
}


int ListArrayMatrixFloydWarshall(listarraymatrix* matrix) {

    int i,j,k;

    for (i=0;i<MATRIX_ROWS;i++)
        for (j=0;j<MATRIX_COLS;j++)
            for (k=0;k<MATRIX_COLS;k++) {

                MATRIX_DATA x,y,z;

                x = ListArrayMatrixGetItem(matrix,i,j);
                y = ListArrayMatrixGetItem(matrix,i,k);
                z = ListArrayMatrixGetItem(matrix,k,j);
                if (x>(y+z))
                    ListArrayMatrixSetValue(matrix,i,j,y+z);
                else ListArrayMatrixSetValue(matrix,i,j,x);
            }

    return 0;
}


int ListArrayMatrixDijkstra(listarraymatrix* matrix, int start, int end) {

    /* values is out of range => END */
    if ((start>MATRIX_ROWS)||(end>MATRIX_COLS)||(start<0)||(end<0))
        return 1;

    /* matrix is NULL => END */
    if (matrix==NULL) return 2;

    ml nodeList = NULL;
    nodesInfoForDijkstra nodes[MATRIX_ROWS];
    int i;

    /* set initial values for nodedistance */
    for (i=0;i<MATRIX_ROWS;i++) {

        nodes[i].distance = INFINITY;
        nodes[i].previous = INFINITY;

        /* set unworked nodes */
        MatrixesPush(&nodeList,INFINITY,i);
    }

    nodes[start].distance = 0;
    nodes[start].previous = start;
    MatrixesChangeValue(&nodeList,0,start);

    /* Main loop */
    while (!MatrixesIsEmpty(nodeList)) {

        /* if's looking node worked break */
        if (MatrixesFindPosition(nodeList,end)==1) break;

        /* looking for node with minimal distance */
        ml temp = nodeList;
        int currentNode = temp->position;
        int minimalDistance = temp->item;

        temp = temp->p_list;
        while (temp!=NULL) {

            if (temp->item<minimalDistance) {

                currentNode = temp->position;
                minimalDistance = temp->item;
            }

            temp = temp->p_list;
        }

        ml temp2 = matrix->matrix[currentNode];
        while (temp2!=NULL) {

            if ((temp2->item!=-1)&&
                    (MatrixesFindPosition(nodeList,temp2->position)==0)) {

                if (nodes[temp2->position].distance>nodes[currentNode].distance+temp2->item) {

                    nodes[temp2->position].distance = nodes[currentNode].distance+temp2->item;
                    nodes[temp2->position].previous = currentNode;
                    MatrixesChangeValue(&nodeList,(nodes[currentNode].distance +
                    temp2->item),temp2->position);
                }
            }
            
            temp2 = temp2->p_list;
        }

        /* Delete current node as worked */
        MatrixesDelete(&nodeList,currentNode);
    }

    /* Write out Path */
    i = 0;
    int currentNode = end;
    printf("%i -> ",end);
    while (currentNode!=start) {

        currentNode = nodes[currentNode].previous;
        i = i + nodes[currentNode].distance;
        printf("%i -> ",currentNode);
    }
    printf("Delka cesty je: %i\n",i);

    return 0;
}
