/* 
 * Tomas Sedmik
 * ramm47@gmail.com
 * 20 04 2009
 */

#ifndef _GRAPHALGORITHM_H
#define	_GRAPHALGORITHM_H

#include "matrixes.h"
#include "onewaylist.h"
#include <limits.h>

#define INFINITY INT_MAX/2
#define UNVISITED -1
#define VISITED 0

typedef struct{

    int distance;
    int previous;

}nodesInfoForDijkstra;

int ArrayMatrixDFS(arraymatrix* matrix, int start, int end);
int ArrayMatrixBFS(arraymatrix* matrix, int start, int end);
int ArrayMatrixFloydWarshall(arraymatrix* matrix);
int ArrayMatrixDijkstra(arraymatrix* matrix, int start, int end);

int ListArrayMatrixDFS(listarraymatrix* matrix, int start, int end);
int ListArrayMatrixBFS(listarraymatrix* matrix, int start, int end);
int ListArrayMatrixFloydWarshall(listarraymatrix* matrix);
int ListArrayMatrixDijkstra(listarraymatrix* matrix, int start, int end);


#endif	/* _GRAPHALGORITHM_H */
