/*
 * Tomas Sedmik
 * ramm47@gmail.com
 * 16 04 2009
 */

#include "matrixes.h"

/* Matrix as 2D array */
/******************************************************************************/

int ArrayMatrixInit(arraymatrix* matrix) {

    int x,y;

    for (x=0;x<MATRIX_ROWS;x++)
        for (y=0;y<MATRIX_COLS;y++)
            matrix->matrix[x][y] = -1;
    
    return 0;
}


int ArrayMatrixRandomFill(arraymatrix* matrix) {

    int x,y;
    int i = 0;

    srand(time(NULL));
    while (i!=DATA_COUNT) {

        x = rand()%MATRIX_ROWS;
        y = rand()%MATRIX_COLS;

        if (matrix->matrix[x][y]==-1) {

            i++;
            matrix->matrix[x][y] = rand()%100;
        }
    }

    return 0;
}


MATRIX_DATA ArrayMatrixGetItem(arraymatrix* matrix, int posx, int posy) {

    return matrix->matrix[posx][posy];
}


int ArrayMatrixSetValue(arraymatrix* matrix, int posx, int posy, MATRIX_DATA value) {

    matrix->matrix[posx][posy] = value;

    return 0;
}

/* Matrix as array of onewaylists */
/******************************************************************************/

int ListArrayMatrixInit(listarraymatrix* matrix) {

    int i;

    for (i=0;i<MATRIX_ROWS;i++)
        matrix->matrix[i] = NULL;

    return 0;
}


int ListArrayMatrixRandomFill(listarraymatrix* matrix) {

    int x,y;
    int i = 0;

    srand(time(NULL));
    while (i!=DATA_COUNT) {

        x = rand()%MATRIX_ROWS;
        y = rand()%MATRIX_COLS;

        if (MatrixesFindPosition(matrix->matrix[x],y)!=0) {

            i++;
            MatrixesPush(&matrix->matrix[x],rand()%100,y);
        }
    }
    
    return 0;
}


MATRIX_DATA ListArrayMatrixGetItem(listarraymatrix* matrix, int posx, int posy) {

    return MatrixesGetItem(matrix->matrix[posx],posy);
}


/*
 * return 0 if's data on position else return 1
 */
int ListArrayMatrixFindPosition(listarraymatrix* matrix, int posx, int posy) {

    return MatrixesFindPosition(matrix->matrix[posx],posy);
}


/*
 * release allocated memory
 */
int ListArrayMatrixDestroy(listarraymatrix* matrix) {

    int i;

    for (i=0;i<MATRIX_ROWS;i++)
        MatrixesDestroy(&matrix->matrix[i]);
    
    return 0;
}


int ListArrayMatrixSetValue(listarraymatrix* matrix, int posx, int posy, MATRIX_DATA value) {

    if (ListArrayMatrixFindPosition(matrix,posx,posy)==1)
        MatrixesPush(&matrix->matrix[posx],value,posy);
    else
        MatrixesChangeValue(&matrix->matrix[posx],value,posy);
    
    return 0;
}


/* Matrix as onewaylist of onewaylists */
/******************************************************************************/

/*
 * Insert item on begin of the list. Call as reference.
 */
int listoflistsPush(lolmatrix* head, int position) {

    lolmatrix InsertData;
    InsertData = (listoflistsmatrix*)malloc(sizeof(listoflistsmatrix));

    InsertData->position = position;
    InsertData->matrixcols = NULL;
    InsertData->p_list = *head;
    *head = InsertData;

    return 0;
}


/*
 * returns item on position. If position doesn't exist return NULL
 */
ml listoflistsGetList(lolmatrix head, int position) {

    while (head!=NULL) {

        if (head->position==position)
            return head->matrixcols;

        head = head->p_list;
    }

    return NULL;
}


/*
 * return 1 if array hasn't data on position, else return 0
 */
int listoflistsFindPosition(lolmatrix head, int pos) {

    if (pos<0)
        return 1;

    int position = 1;

    while((head!=NULL)&&(position==1)) {

        if (head->position==pos) position = 0;
        head = head->p_list;
    }

    return position;
}


int ListOfListsMatrixRandomFill(lolmatrix* matrix) {

    int x,y;
    int i = 0;

    srand(time(NULL));
    while (i<20) {

        x = rand()%MATRIX_ROWS;
        y = rand()%MATRIX_COLS;

        if (listoflistsFindPosition(*matrix,10)==1) {

            ml matrixcol = listoflistsGetList(*matrix,10);

            listoflistsPush(&(*matrix),x);
            MatrixesPush(&matrixcol,rand()%100,y);
            (*matrix)->matrixcols = matrixcol;
            i++;
        }
        else {

            ml matrixcol = listoflistsGetList(*matrix,x);

            if (MatrixesFindPosition(matrixcol,y)==1) {

                MatrixesPush(&matrixcol,rand()%100,y);
                (*matrix)->matrixcols = matrixcol;
                i++;
            }
        }
    }

    return 0;
}


MATRIX_DATA ListOfListsMatrixGetItem(lolmatrix matrix, int posx, int posy) {

    ml matrixcol = listoflistsGetList(matrix,posx);

    return MatrixesGetItem(matrixcol,posy);
}


/*
 * return 0 if's data on position else return 1
 */
int ListOfListsMatrixFindPosition(lolmatrix matrix, int posx, int posy) {

    if (listoflistsFindPosition(matrix,posx)==0) {
        
        ml matrixcol = listoflistsGetList(matrix,posx);

        if (MatrixesFindPosition(matrixcol,posy)==0) return 0;
    }

    return 1;
}


/*
 * release allocated memory. Call as reference!
 */
int ListOfListsMatrixDestroy(lolmatrix* matrix) {

    lolmatrix temp;

    while ((*matrix)!=NULL) {
        temp = *matrix;
        *matrix = temp->p_list;
        ml list = temp->matrixcols;
        MatrixesDestroy(&list);
        free(temp);
    }
    free(*matrix);

    return 0;
}


/* One way list functions for matrixes */
/******************************************************************************/


/*
 * return 1 if array hasn't data on position, else return 0
 */
int MatrixesFindPosition(ml head, int pos) {

    if (pos<0)
        return 1;

    int position = 1;

    while((head!=NULL)&&(position==1)) {

        if (head->position==pos) position = 0;
        head = head->p_list;
    }

    return position;
}


/*
 * Insert item on begin of the list. Call as reference.
 */
int MatrixesPush(ml* head, matrixdata item, int position) {

    ml InsertData;
    InsertData = (MatrixList*)malloc(sizeof(MatrixList));

    InsertData->item = item;
    InsertData->position = position;
    InsertData->p_list = *head;
    *head = InsertData;

    return 0;
}


/*
 * returns item on position. If position doesn't exist return -1
 */
matrixdata MatrixesGetItem(ml head, int position) {

    while (head!=NULL) {

        if (head->position==position)
            return head->item;

        head = head->p_list;
    }

    return -1;
}


/*
 * Deallocation memory, call as reference
 */
int MatrixesDestroy(ml* head) {

    ml temp;

    while ((*head)!=NULL) {
        temp = *head;
        *head = temp->p_list;
        free(temp);
    }
    free(*head);

    return 0;
}

/*
 * Change value on position
 */
int MatrixesChangeValue(ml* head, matrixdata item, int position) {

    ml temp;
    int i;

    temp = *head;
    while(temp!=NULL) {

        if (temp->position == position) {

            temp->item = item;
            return 0;
        }
        else temp = temp->p_list;
    }
    
    return 1;
}


int MatrixesIsEmpty(const ml head) {

    return (head==NULL) ? 1 : 0;
}


int MatrixesDelete(ml* head, int position) {

    if (position==(*head)->position) MatrixesPop(head);
    else {

        ml temp;
        ml temp2;

        temp = *head;
        while (temp!=NULL) {

            if (position==temp->position) {

                temp2->p_list = temp->p_list;
                free(temp);
                break;
            }

            temp2 = temp;
            temp = temp->p_list;
        }
    }

    return 0;
}

int MatrixesPop(ml* head) {

    ml temp;

    temp = *head;
    if ((*head)->p_list==NULL) *head = NULL;
    else *head = (*head)->p_list;
    free(temp);

    return 0;
}
