#include <stdio.h>
#include <stdlib.h>
#include "graphalgorithm.h"

void GetInput(int* start, int* end) {

    char line[256];

    printf("Zadej vychozi pozici v grafu: ");
    fgets (line,256,stdin);
    *start = atoi (line);

    printf("Zadejte hledany uzel v grafu: ");
    fgets (line,256,stdin);
    *end = atoi (line);
}

void ArrayMatrixQuery(arraymatrix graph) {

    int start, end;

    GetInput(&start,&end);
    ArrayMatrixDijkstra(&graph,start,end);
}

void ListArrayMatrixQuery(listarraymatrix graph) {

    int start, end;

    GetInput(&start,&end);
    ListArrayMatrixDijkstra(&graph,start,end);
}

int main() {

    /* graph as array */
    {
        arraymatrix graph;

        ArrayMatrixInit(&graph);
        ArrayMatrixRandomFill(&graph);
        ArrayMatrixQuery(graph);
    }

    /* graph as array of lists */
    {
        listarraymatrix graph;

        ListArrayMatrixInit(&graph);
        ListArrayMatrixRandomFill(&graph);
        ListArrayMatrixQuery(graph);
        ListArrayMatrixDestroy(&graph);
    }

    return 0;
}

