package cz.muni.fi.pb162.task2;


/**
 * Interface for rechargeable devices.
 * 
 * @author Radek Oslejsek, oslejsek@fi.muni.cz
 * @version 2009-09-23
 */
public interface Chargeable
{
    /**
     * Returns current battery charge (state).
     * 
     * @return battery charge in the rage 0-100 
     *         (0 = discharged, 100 = fully charged)
     */
    int getBatteryState();
    
    /**
     * Charging step. Increases the battery state by 1.
     * If the battery is fully charged, nothing happens.
     * 
     * @return battery state after the charging step in the range 0-100
     */
    int charge();
    
    /**
     * Discharging step. Decreases the battery state by 1.
     * If the battery is fully discharged, nothing happens.
     * 
     * @return battery state after the discharging step in the range 0-100
     */
    int discharge();    
}
