package cz.muni.fi.pb162.task2;

/** 
 * Class represent Cell phone and its function
 * 
 * @author Tomas Sedmik 
 * @version 20 10 2009
 */
public class MobilePhone implements Phone, Chargeable{

    private String number;
    private int batteryState;

    
    /**
     * Default contructor
     */
    public MobilePhone() {
    }
    
    
    /**
     * Constructor
     * 
     * @param charge represent amount of charge which's in the device
     */
    public MobilePhone(int charge) {
            
            batteryState = charge;
            number = null;
    }
    
    /**
     * Dials the number, starts the call.
     * 
     * @param number called number
     */
    public void dial(String number) {
    
        this.number = number;
    }
    
    /**
     * Returns currently called number.
     * 
     * @return currently called number during the call (phone conversation), 
     *         null if the phone is hang up (nobody is connected).
     */
    public String connectedNumber() {
        
        return number;
    }

    /**
     * Hangs up the phone.
     */
    public void hangUp() {
        
        number = null;
    }
    
    /**
     * Returns current battery charge (state).
     * 
     * @return battery charge in the rage 0-100 
     *         (0 = discharged, 100 = fully charged)
     */
    public int getBatteryState() {
        
        return batteryState;
    }
    
    /**
     * Charging step. Increases the battery state by 1.
     * If the battery is fully charged, nothing happens.
     * 
     * @return battery state after the charging step in the range 0-100
     */
    public int charge() {
        
        if (batteryState<100) {
            
            batteryState++;
        }
        
        return batteryState;
    }
    
    
    /**
     * Discharging step. Decreases the battery state by 1.
     * If the battery is fully discharged, nothing happens.
     * 
     * @return battery state after the discharging step in the range 0-100
     */
    public int discharge() {
        
        if (batteryState>0) {
            
            batteryState--;
        }
        
        return batteryState;
    }
    
}
