/**
 * Abstract class AbstractCodingDevice represent common type of Coding device. Saves value of key.
 * 
 * @author Tomas Sedmik, xsedmik@fi.muni.cz
 * @version 29 10 2009
 */
public abstract class AbstractCodingDevice implements CodingDevice {
    
    private String key;

    /**
     * Constructor
     *
     * @param key is coding passphrase
     */
    public AbstractCodingDevice(String key) {
        
        this.key = key;
    }
    
    /**
     * Get key value
     *
     * @return key value
     */
    public String getKey() {
        
        return key;
    }
    
    /**
     * Set up key value
     * 
     * @param key is coding passphrase
     */
    public void setKey(String key) {
        
        this.key = key;
    }
    
    public abstract String encode(String text);
    public abstract String decode(String text);
}
