/**
 * Implements Ceasar's coding algorithm
 * 
 * @author Tomas Sedmik, xsedmik@fi.muni.cz
 * @version 29 10 2009
 */
public class Ceasar extends AbstractCodingDevice {

    /**
     * Constructor that sets the key.
     * @param key used for encoding/decoding
     */
    public Ceasar(String key) {
        
        super(key);
    }
    
     /**
     * Encode a message
     * @param text message which will be encoded
     */
    public String encode(String text) {
        
        char[] textArr = text.toCharArray();
        char[] keyArr = getKey().toCharArray();
        char[] result = new char[text.length()];
        int abcLength = 'z' - 'a' + 1;
        
        for (int i=0; i<textArr.length; i++) {
            
            int intKey = keyArr[i % keyArr.length] - 'a' + 1;
            int newOrd = (textArr[i] - 'a' + intKey) % abcLength;
            result[i] = (char)('a' + newOrd); 
        }
        
        return new String(result);
    }
    
     /**
     * Decode a message
     * @param text message which will be decoded
     */
    public String decode(String text) {
        
        char[] textArr = text.toCharArray();
        char[] keyArr = getKey().toCharArray();
        char[] result = new char[text.length()];
        int abcLength = 'z' - 'a' + 1;
        
        for (int i=0; i<textArr.length; i++) {
            
            int intKey = keyArr[i % keyArr.length] - 'a' + 1;
            int newOrd = (textArr[i] - 'a' - intKey) % abcLength;
            if(newOrd < 0) newOrd += abcLength;
            result[i] = (char)('a' + newOrd); 
        }
        
        return new String(result);
    }
}
