/**
 * Write a description of interface CodingDevice here.
 * 
 * @author Tomas Sedmik, xsedmik@fi.muni.cz 
 * @version 29 10 2009
 */

public interface CodingDevice
{
    /**
     * Gets the key used for encoding/decoding
     * @return key
     */
    String getKey();
    
    /**
     * Sets the key used for encoding/decoding
     * @param key key used for encoding/decoding
     */
    void setKey(String key);
    
    /**
     * Encodes text with the key
     * @param text text to be encoded
     * @return encoded text
     */
    String encode(String text);
    
    /**
     * Decodes text with the key
     * @param text text to decoded
     * @return decoded text
     */
    String decode(String text);
}
