/**
 * Implements Vernam's coding algorithm
 * 
 * @author Tomas Sedmik
 * @version 29 10 2009
 */
public class Vernam extends AbstractCodingDevice {
    
    /**
     * Constructor that sets the key used for encoding/decoding
     * @param key the key used for encoding/decoding. 
     */
    public Vernam(String key) {
        
        super(key);
    }
    
    /**
     * Encode a message
     * @param text message which will be encoded
     */
    public String encode(String text) {
        
        char[] textArray = text.toCharArray();
        char[] keyArray = getKey().toCharArray();
        char[] result = new char[ textArray.length ];
        
        for (int i=0; i < textArray.length; i++) {
            
            result[i] = (char)(textArray[i] ^ keyArray[i % keyArray.length]);
        }
        
        return new String(result);
    }
    
    /**
     * Decode a message
     * @param text message which will be decoded
     */
    public String decode(String text) {
    
        return encode(text);
    }
}
