package cz.muni.fi.pb162.task2;

/**
 * Class abstracts the common functionality of the lower classes (abstract medium 
 * for the transmission of messages) 
 *
 * @author Tomas Sedmik, xsedmik@fi.muni.cz
 * @version 06 11 2009
 */
public abstract class AbstractMessaging implements Messaging{
    
    private Message msg;

    /**
     * Sets the message.
     * 
     * @param msg Message for delivery
     */
    public void setMessage(Message msg) {
        
        this.msg = msg;
    }
    
    /**
     * @return delivered message
     */
    public Message getMessage() {
        
        return msg;
    }
    

    /**
     * Simulates message delivery. This method will just write the following
     * text into the std. output:
     * 
     * "Message to <addressee> will arrive in <X> hours."
     * 
     * where <addressee> is message addressee and <X> is delivery time.
     */
    public void send() {
        
        System.out.println("Message to " + msg.getAddressee() + " will arrive in "
        + deliveryTime() + " hours.");
    }
    
    /**
     * Calculates approximate delivery time.
     * 
     * @return approximate delivery time in hours
     */
    public abstract double deliveryTime();
    
}
