package cz.muni.fi.pb162.task2;


/**
 * Message delivery in various ways, e.g. via classical mail, by pigeon, etc.
 * 
 * @author Radek Oslejsek, oslejsek@fi.muni.cz
 * @version 2009-10-14
 */

public interface DeliveryService
{
    /**
     * Sets messaging type to express mail.
     */
    void setExpressMailMessaging();
    
    /**
     * Sets messaging type to standard mail.
     */
    void setStandardMailMessaging();
    
    /**
     * Sets messaging type to pigeon.
     * 
     * @param fitness Pigeon fittness
     * @param distance Distance of the pigeon from addressee
     */
    void setPigeonMessaging(int fitness, int distance);
    
    /**
     * Simulates message delivery. This method takes a message as input 
     * parameter, passes it on the messenger (pigeon, mail, ...) 
     * and then lets the messanger send the message.
     * 
     * @param msg Message to send
     */
    void sendMessage(Message msg);
}
