package cz.muni.fi.pb162.task2;

/**
 * Implements the DeliveryService interface 
 *
 * @author Tomas Sedmik, xsedmik@fi.muni.cz 
 * @version 06 11 2009
 */
public class DeliveryServiceImpl implements DeliveryService {

    private Messaging msgType;
   
    /**
     * Constructor creates default delivery service via standart mail
     */
    public DeliveryServiceImpl() {
    
        setStandardMailMessaging();
    }
    
    /**
     * Sets messaging type to express mail.
     */
    public void setExpressMailMessaging() {
    
        msgType = new Mail(Mail.EXPRESS);
    }
    
    /**
     * Sets messaging type to standard mail.
     */
    public void setStandardMailMessaging() {
        
        msgType = new Mail(Mail.STANDART);
    }
    
    /**
     * Sets messaging type to pigeon.
     * 
     * @param fitness Pigeon fittness
     * @param distance Distance of the pigeon from addressee
     */
    public void setPigeonMessaging(int fitness, int distance) {
    
        msgType = new Pigeon(fitness);
        ((Pigeon)msgType).setDistance(distance);
    }
    
    /**
     * Simulates message delivery. This method takes a message as input 
     * parameter, passes it on the messenger (pigeon, mail, ...) 
     * and then lets the messanger send the message.
     * 
     * @param msg Message to send
     */
    public void sendMessage(Message msg) {
    
        msgType.setMessage(msg);
        msgType.send();
        
    }

}
