package cz.muni.fi.pb162.task2;


/**
 * Class delivers messages through the mail (express or standard)
 * 
 * @author Tomas Sedmik, xsedmik@fi.muni.cz
 * @version 06 11 2009
 */
public class Mail extends AbstractMessaging {

    // constants
    public static final int STANDART = 72;
    public static final int EXPRESS = 24;

    private final int timeToDelivery;

    /**
     * Constructor.
     * 
     * @param msgType type of message: standart or express
     */
    public Mail(int msgType) {
    
        timeToDelivery = (msgType == STANDART ? STANDART : EXPRESS);
    }
    
    /**
     * Constructor.
     * 
     * @param msgType type of message: standart or express
     * @param msg message to delivery
     */
    public Mail(int msgType, Message msg) {
    
        this(msgType);
        setMessage(msg);
    }
    
    /**
     * Calculates approximate delivery time.
     * 
     * @return approximate delivery time in hours
     */
    public double deliveryTime() {
        
        return timeToDelivery;
    }
    
}
