package cz.muni.fi.pb162.task2;


/**
 * This interface enables us to send messages and calculate approximate 
 * delivery time.
 * 
 * @author Radek Oslejsek, oslejsek@fi.muni.cz
 * @version 2009-10-14
 */
public interface Messaging
{
    /**
     * Sets the message.
     * 
     * @param msg Message for delivery
     */
    void setMessage(Message msg);
    
    /**
     * @return delivered message
     */
    Message getMessage();
    
    /**
     * Simulates message delivery. This method will just write the following
     * text into the std. output:
     * 
     * "Message to <addressee> will arrive in <X> hours."
     * 
     * where <addressee> is message addressee and <X> is delivery time.
     */
    void send();
    
    /**
     * Calculates approximate delivery time.
     * 
     * @return approximate delivery time in hours
     */
    double deliveryTime();
}
