package cz.muni.fi.pb162.task2;

/**
 * Class sends messages via carrier pigeon which has the shape and the distance to be flown 
 *
 * @author Tomas Sedmik
 * @version 06 11 2009
 */
public class Pigeon extends AbstractMessaging {

    public static final int PIDGEONSPEED = 20;

    private int condition;
    private int distance;
    
    /**
     * Constructor.
     * 
     * @param condition represent a condition pigeon (range 0-100)
     */
    public Pigeon(int condition) {
        
        if (condition > 100) {
        
            this.condition = 100;
        } else if (condition < 0) {
            
            this.condition = 0;
        } else {
    
            this.condition = condition;
        }
    }
    
    /**
     * Constructor.
     * 
     * @param condition represent a condition pigeon (range 0-100)
     * @param msg message to delivery
     */
    public Pigeon(int condition, Message msg) {
        
        this(condition);
        setMessage(msg);
    }
    
    /**
     * Sets distance for message delivery.
     *
     * @param distance Distance for message delivery in km
     */
    public void setDistance(int distance) {

        this.distance = distance;
    }

    /**
     * Calculates approximate delivery time.
     * 
     * @return approximate delivery time in hours
     */
    public double deliveryTime() {
        
        return (100.0 * distance) / (PIDGEONSPEED * condition);
    }

}
