package cz.muni.fi.pb162.test.concentration;

/**
 * This class represents card that has color and a picture. Both color and picture 
 * distinguish one card pair from another. 
 *
 * <p>Created 28.11.2009 at 0:21:45.
 *
 * @author Rastislav Mirek <rmirek at mail.muni.cz>
 * @version %I%, %G%
 */
public class Card {

    private String color;
    private String picture;

    /**
     * Creates new Card.
     *
     * @param color Color of card. May not be {@code null}.
     * @param picture Card's picture. May not be {@code null}.
     */
    public Card(String color, String picture){
        if(color == null){
            throw new NullPointerException("color");
        }
        if(picture == null){
            throw new NullPointerException("picture");
        }
        this.color = color;
        this.picture = picture;
    }

    @Override
    public String toString() {
        return color + "/" + picture;
    }

    public boolean equals(Object o) {
        
        if ((o != null) 
            && (o instanceof Card) 
            && ((this.toString()).equals(o.toString()))) {
            
            return true;  
        }
            
        return false;
    }
    
    public int hashCode() {
        
        return (this.toString()).hashCode();
    }
}
