package cz.muni.fi.pb162.test.concentration;

/**
 * Represents game plane in desktop game called Concentration (also known as Memory).
 * To play the game, the uncoverFirstCard() and uncoverSecondCard() methods 
 * have to be invoked in turns, uncoverFirtsCard() before the uncoverSecondCard().
 *
 * <p>Created 28.11.2009 at 20:54:36.
 *
 * @version %I%, %G%
 */
public interface ConcentrationDesk {

    /**
     * Uncovers first card.
     * 
     * @param index Index of the card to be uncovered, 0 = first card
     * @return Uncovered card.
     * @throws NoCardException If there is no card at the index.
     * @throws IllegalOperationException If this method has been already 
     *         invoked without subsequent invocation of uncoverSecondCard().
     */
    Card uncoverFirstCard(int index) throws ConcentrationException;
    
    /**
     * Uncovers second card. If both the uncovered cards on the desk 
     * match each other then they are removed from the desk.
     * If they don't match they are covered back.
     * 
     * @param index Index of the card to be uncovered, 0 = first card.
     * @throws NoCardException If there is no card at the index.
     * @throws IllegalOperationException If the first card was not uncovered yet, 
     *         i.e. the uncoverFirstCard() method was not invoked.
     * @throws UncoveredCardException If the second card is the first 
     *         (already uncovered) card
     */
    boolean uncoverSecondCard(int index) throws ConcentrationException;
    
    /**
     * @param index Index of the card to be returned, 0 = first card.
     * @return Card at the given index or null.
     */
    Card cardAt(int index);
}
