package cz.muni.fi.pb162.test.concentration;

/**
 * @author Tomas Sedmik, xsedmik@fi.muni.cz
 * @version 12 11 2009
 */
public class ConcentrationDeskImpl implements ConcentrationDesk {

    private Card[] cardsArray;
    private int indexOfFirstCard = -1;
    
    public ConcentrationDeskImpl(Card[] cards) throws IllegalCardSetException {
        
        if (cards==null) {
            
            IllegalCardSetException exc = new IllegalCardSetException("Input array is null.");
            throw exc;
        } 
        else {
            
            for (Card card : cards) {
                
                if (card==null) {
                    
                    IllegalCardSetException exc = new IllegalCardSetException("Input array is invalid. Some card is null");
                    throw exc;            
                }
            }
            
            for (int i = 0; i < cards.length; i++) {
                
                boolean isMatch = false;
                
                for (int j = 0; j < cards.length; j++) {
                
                    if ((i!=j) && (cards[i].equals(cards[j]))) {
                        
                        if (isMatch) {
                            
                            isMatch = false;
                        }
                        else {
                            
                            isMatch = true;
                        }
                    }
                }
                
                if (!isMatch) {
                    
                    IllegalCardSetException exc = new IllegalCardSetException("Input array has invalid length (Doesn't makes pair).");
                    throw exc;            
                }
                
            }
            
            cardsArray = new Card[cards.length];
            System.arraycopy(cards, 0, cardsArray, 0, cards.length);
        }
    }

    /**
     * Uncovers first card.
     * 
     * @param index Index of the card to be uncovered, 0 = first card
     * @return Uncovered card.
     * @throws NoCardException If there is no card at the index.
     * @throws IllegalOperationException If this method has been already 
     *         invoked without subsequent invocation of uncoverSecondCard().
     */
    public Card uncoverFirstCard(int index) throws ConcentrationException {
        
        if ((index < 0) || (index >= cardsArray.length) || (cardsArray[index] == null)) {
            
            NoCardException exc = new NoCardException("There isn't no card at the index");
            throw exc;
        }
        
        if (indexOfFirstCard != -1) {
            
            IllegalOperationException exc = new IllegalOperationException("this method has been already invoked without subsequent invocation of uncoverSecondCard()");
            throw exc;
        }
        
        indexOfFirstCard = index;

        return cardAt(indexOfFirstCard);
    }
    
    /**
     * Uncovers second card. If both the uncovered cards on the desk 
     * match each other then they are removed from the desk.
     * If they don't match they are covered back.
     * 
     * @param index Index of the card to be uncovered, 0 = first card.
     * @throws NoCardException If there is no card at the index.
     * @throws IllegalOperationException If the first card was not uncovered yet, 
     *         i.e. the uncoverFirstCard() method was not invoked.
     * @throws UncoveredCardException If the second card is the first 
     *         (already uncovered) card
     */
    public boolean uncoverSecondCard(int index) throws ConcentrationException {
        
        if ((index < 0) || (index >= cardsArray.length) || (cardsArray[index] == null)) {
            
            NoCardException exc = new NoCardException("There isn't no card at the index");
            throw exc;
        }
        
        if (indexOfFirstCard == -1) {
            
            IllegalOperationException exc = new IllegalOperationException("the first card was not uncovered yet");
            throw exc;
        }
        
        if (index == indexOfFirstCard) {
            
            UncoveredCardException exc = new UncoveredCardException("the second card is the first (already uncovered) card");
            throw exc;
        }
        
        boolean isMatch = cardAt(indexOfFirstCard).equals(cardsArray[index]);
        
        
        if (isMatch) {
            
            cardsArray[index] = null;
            cardsArray[indexOfFirstCard] = null;
        }
        
        indexOfFirstCard = -1;
        
        return isMatch;
    }
    
    /**
     * @param index Index of the card to be returned, 0 = first card.
     * @return Card at the given index or null.
     */
    public Card cardAt(int index) {
        
        if (index > cardsArray.length) {
            
            return null;
        }
        
        return cardsArray[index];
    }
    
}
